/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.jei;

import de.maxhenkel.car.blocks.BlockCarWorkshop;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.integration.jei.CarRecipe;
import de.maxhenkel.car.integration.jei.JEIPlugin;
import de.maxhenkel.tools.EntityTools;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CarRecipeCategory
implements IRecipeCategory<CarRecipe> {
    protected static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/jei_car_workshop_crafting.png");
    private static final int RECIPE_WIDTH = 175;
    private static final int RECIPE_HEIGHT = 54;
    private final IGuiHelper helper;
    private final IDrawableStatic background;
    private EntityTools.SimulatedCarRenderer renderer = new EntityTools.SimulatedCarRenderer();

    public CarRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(BACKGROUND, 0, 0, this.getWidth(), this.getHeight());
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CAR_WORKSHOP.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CarRecipe recipe, IFocusGroup focuses) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 5; ++x) {
                ItemStack stack;
                IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1);
                int index = x + y * 5;
                if (index >= recipe.getInputs().size() || (stack = recipe.getInputs().get(index)).isEmpty()) continue;
                slot.add((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            }
        }
    }

    public IRecipeType<CarRecipe> getRecipeType() {
        return JEIPlugin.CATEGORY_CAR_WORKSHOP;
    }

    public Component getTitle() {
        return ((BlockCarWorkshop)((Object)ModBlocks.CAR_WORKSHOP.get())).getName();
    }

    public void draw(CarRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        int x = (int)guiGraphics.pose().m20;
        int y = (int)guiGraphics.pose().m21;
        this.renderer.render(guiGraphics, this.getCar(recipe), x + 115, y + 5, x + 174, y + 49, 18);
    }

    public EntityGenericCar getCar(CarRecipe recipe) {
        return recipe.getCachedCar(() -> this.createCar((Level)Minecraft.getInstance().level, recipe));
    }

    private EntityGenericCar createCar(Level world, CarRecipe recipe) {
        return TileEntityCarWorkshop.createCar(world, recipe.getInputs());
    }

    public int getWidth() {
        return 175;
    }

    public int getHeight() {
        return 54;
    }
}

