/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.jei;

import de.maxhenkel.car.integration.jei.JEIPlugin;
import de.maxhenkel.car.integration.jei.PainterRecipe;
import de.maxhenkel.car.items.ItemPainter;
import de.maxhenkel.car.items.ModItems;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PainterRecipeCategory
implements IRecipeCategory<PainterRecipe> {
    protected static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/jei_painter.png");
    protected final IGuiHelper helper;
    protected final IDrawableStatic background;

    public PainterRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(BACKGROUND, 0, 0, this.getWidth(), this.getHeight());
    }

    public void draw(PainterRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.PAINTER.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PainterRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 19).add((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)recipe.getInput()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 19).add((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)recipe.getOutput()));
    }

    public IRecipeType<PainterRecipe> getRecipeType() {
        return JEIPlugin.CATEGORY_PAINTER;
    }

    public Component getTitle() {
        return ((ItemPainter)((Object)ModItems.PAINTER.get())).getName();
    }

    public int getWidth() {
        return 80;
    }

    public int getHeight() {
        return 54;
    }
}

