/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.waila;

import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.integration.waila.PluginCar;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerCars
implements IEntityComponentProvider {
    public static final HUDHandlerCars INSTANCE = new HUDHandlerCars();
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"car");

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        iTooltip.remove(PluginCar.OBJECT_NAME_TAG);
        iTooltip.add((Component)entityAccessor.getEntity().getDisplayName().copy().withStyle(ChatFormatting.WHITE));
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof EntityGenericCar) {
            float damage;
            EntityGenericCar car = (EntityGenericCar)entity;
            FluidResource carFluid = car.getResource(0);
            int carFluidAmount = car.getAmountAsInt(0);
            if (carFluidAmount > 0) {
                iTooltip.add((Component)Component.translatable((String)"tooltip.waila.car.fuel", (Object[])new Object[]{carFluid.getHoverName()}));
                iTooltip.add((Component)Component.translatable((String)"tooltip.waila.car.fuel_amount", (Object[])new Object[]{carFluidAmount, car.getMaxFuel()}));
            }
            if ((damage = car.getDamage()) > 0.0f) {
                iTooltip.add((Component)Component.translatable((String)"tooltip.waila.car.damage", (Object[])new Object[]{Float.valueOf(MathUtils.round(damage, 2))}));
            }
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

