/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.tools.IntegerJournal;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ItemBattery
extends Item {
    public ItemBattery(Item.Properties properties) {
        super(properties.stacksTo(1).durability(500));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag flag) {
        consumer.accept((Component)Component.translatable((String)"tooltip.battery_energy", (Object[])new Object[]{Component.literal((String)String.valueOf(this.getEnergy(stack))).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        consumer.accept((Component)Component.translatable((String)"tooltip.battery").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltipDisplay, consumer, flag);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        EnergyHandler energyHandler;
        if (context.getLevel().getBlockState(context.getClickedPos()).getBlock().equals(ModBlocks.GENERATOR.get()) && (energyHandler = (EnergyHandler)context.getLevel().getCapability(Capabilities.Energy.BLOCK, context.getClickedPos(), (Object)context.getClickedFace())) != null) {
            int amount;
            ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
            int energyToFill = stack.getDamageValue();
            try (Transaction transaction = Transaction.open(null);){
                amount = energyHandler.extract(energyToFill, (TransactionContext)transaction);
                transaction.commit();
            }
            stack.setDamageValue(energyToFill - amount);
            context.getPlayer().setItemInHand(context.getHand(), stack);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public int getEnergy(ItemStack stack) {
        return this.getMaxDamage(stack) - this.getDamage(stack);
    }

    public void setEnergy(ItemStack stack, int energy) {
        this.setDamage(stack, Math.max(this.getMaxDamage(stack) - energy, 0));
    }

    public EnergyHandler getEnergyHandler(ItemStack stack) {
        return new BatteryEnergyStorage(stack);
    }

    public class BatteryEnergyStorage
    implements EnergyHandler {
        private ItemStack stack;
        private final SnapshotJournal<Integer> energyJournal = new IntegerJournal(integer -> ItemBattery.this.setEnergy(this.stack, (int)integer), () -> ItemBattery.this.getEnergy(this.stack));

        public BatteryEnergyStorage(ItemStack stack) {
            this.stack = stack;
        }

        public long getAmountAsLong() {
            return ItemBattery.this.getEnergy(this.stack);
        }

        public long getCapacityAsLong() {
            return ItemBattery.this.getMaxDamage(this.stack);
        }

        public int insert(int amount, TransactionContext transaction) {
            int result = Math.min(amount, ItemBattery.this.getMaxDamage(this.stack) - ItemBattery.this.getEnergy(this.stack));
            this.energyJournal.updateSnapshots(transaction);
            ItemBattery.this.setEnergy(this.stack, ItemBattery.this.getEnergy(this.stack) + result);
            return result;
        }

        public int extract(int amount, TransactionContext transaction) {
            return 0;
        }
    }
}

