/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;

public class ItemCanister
extends Item {
    public ItemCanister(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity te;
        if (!context.getPlayer().isShiftKeyDown()) {
            return super.useOn(context);
        }
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        BlockPos tePos = context.getClickedPos();
        if (state.getBlock().equals(ModBlocks.GAS_STATION_TOP.get())) {
            tePos = context.getClickedPos().below();
        }
        if ((te = context.getLevel().getBlockEntity(tePos)) == null) {
            return super.useOn(context);
        }
        ItemAccess itemAccess = ItemAccess.forPlayerInteraction((Player)context.getPlayer(), (InteractionHand)context.getHand());
        if (te instanceof TileEntityGasStation) {
            TileEntityGasStation gasStation = (TileEntityGasStation)te;
            if (gasStation.hasTrade()) {
                return super.useOn(context);
            }
            boolean success = ItemCanister.fillCanister(itemAccess, gasStation.getFluidHandler());
            if (success) {
                ModSounds.playSound(SoundEvents.BREWING_STAND_BREW, context.getLevel(), context.getClickedPos(), null, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        ResourceHandler capability = (ResourceHandler)context.getLevel().getCapability(Capabilities.Fluid.BLOCK, tePos, (Object)context.getClickedFace());
        if (capability != null) {
            boolean success = ItemCanister.fuelFluidHandler(itemAccess, (ResourceHandler<FluidResource>)capability);
            if (success) {
                ModSounds.playSound(SoundEvents.BREWING_STAND_BREW, context.getLevel(), context.getClickedPos(), null, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag flag) {
        SimpleFluidContent content = (SimpleFluidContent)stack.get(CarMod.FUEL_DATA_COMPONENT);
        if (content == null || content.isEmpty()) {
            this.addInfo("-", 0, consumer);
            super.appendHoverText(stack, context, tooltipDisplay, consumer, flag);
            return;
        }
        FluidStack fluidStack = content.copy();
        this.addInfo(fluidStack.getHoverName().getString(), fluidStack.getAmount(), consumer);
        super.appendHoverText(stack, context, tooltipDisplay, consumer, flag);
    }

    private void addInfo(String fluid, int amount, Consumer<Component> consumer) {
        consumer.accept((Component)Component.translatable((String)"canister.fluid", (Object[])new Object[]{Component.literal((String)fluid).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        consumer.accept((Component)Component.translatable((String)"canister.amount", (Object[])new Object[]{Component.literal((String)String.valueOf(amount)).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
    }

    public static boolean fillCanister(ItemAccess canister, ResourceHandler<FluidResource> handler) {
        ResourceHandler canisterHandler = (ResourceHandler)canister.getCapability(Capabilities.Fluid.ITEM);
        int moved = ResourceHandlerUtil.move(handler, (ResourceHandler)canisterHandler, resource -> true, (int)Integer.MAX_VALUE, null);
        return moved > 0;
    }

    public static boolean fuelFluidHandler(ItemAccess canister, ResourceHandler<FluidResource> handler) {
        ResourceHandler canisterHandler = (ResourceHandler)canister.getCapability(Capabilities.Fluid.ITEM);
        int moved = ResourceHandlerUtil.move((ResourceHandler)canisterHandler, handler, resource -> true, (int)Integer.MAX_VALUE, null);
        return moved > 0;
    }
}

