/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.blocks.BlockGuardRail;
import de.maxhenkel.car.blocks.ModBlocks;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemGuardRail
extends BlockItem {
    public ItemGuardRail(Item.Properties properties) {
        super((Block)ModBlocks.GUARD_RAIL.get(), properties.useBlockDescriptionPrefix());
    }

    public InteractionResult place(BlockPlaceContext context) {
        BlockState clickedBlock;
        BlockPlaceContext bc = this.updatePlacementContext(context);
        if (bc == null) {
            return super.place(context);
        }
        Level world = context.getLevel();
        Direction face = bc.getClickedFace();
        if (face.getStepY() != 0) {
            face = bc.getHorizontalDirection();
        }
        if ((clickedBlock = world.getBlockState(bc.getClickedPos())).getBlock() != this.getBlock()) {
            return super.place(context);
        }
        BooleanProperty property = ((BlockGuardRail)((Object)ModBlocks.GUARD_RAIL.get())).getProperty(face);
        if (((Boolean)clickedBlock.getValue((Property)property)).booleanValue()) {
            return super.place(context);
        }
        BlockState place = (BlockState)clickedBlock.setValue((Property)property, (Comparable)Boolean.valueOf(true));
        if (!this.placeBlock(bc, place)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = bc.getClickedPos();
        Player playerentity = bc.getPlayer();
        ItemStack itemstack = bc.getItemInHand();
        BlockState placed = world.getBlockState(blockpos);
        Block block = placed.getBlock();
        if (block == place.getBlock()) {
            this.updateCustomBlockEntityTag(blockpos, world, playerentity, itemstack, placed);
            block.setPlacedBy(world, blockpos, placed, (LivingEntity)playerentity, itemstack);
            if (playerentity instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)playerentity, blockpos, itemstack);
            }
        }
        SoundType soundtype = placed.getSoundType((LevelReader)world, blockpos, (Entity)context.getPlayer());
        world.playSound((Entity)playerentity, blockpos, this.getPlaceSound(placed, world, blockpos, context.getPlayer()), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        if (playerentity == null || !playerentity.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }
}

