/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.gui.ContainerLicensePlate;
import de.maxhenkel.car.items.ItemCraftingComponent;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class ItemLicensePlate
extends ItemCraftingComponent {
    public ItemLicensePlate(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag flag) {
        String text = ItemLicensePlate.getText(stack);
        if (!text.isEmpty()) {
            consumer.accept((Component)Component.translatable((String)"tooltip.license_plate_text", (Object[])new Object[]{Component.literal((String)text).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltipDisplay, consumer, flag);
    }

    public InteractionResult use(Level worldIn, final Player playerIn, final InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return ItemLicensePlate.this.getName(playerIn.getItemInHand(handIn));
                }

                @Nullable
                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerLicensePlate(i, playerIn.getItemInHand(handIn));
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public static void setText(ItemStack stack, String text) {
        stack.set(CarMod.LICENSE_PLATE_TEXT_DATA_COMPONENT, (Object)text);
    }

    @Nonnull
    public static String getText(ItemStack stack) {
        return (String)stack.getOrDefault(CarMod.LICENSE_PLATE_TEXT_DATA_COMPONENT, (Object)"");
    }
}

