/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.loottable;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;

public class CopyFluid
extends LootItemConditionalFunction {
    public static final MapCodec<CopyFluid> CODEC = RecordCodecBuilder.mapCodec(instance -> CopyFluid.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CopyFluid::new));

    protected CopyFluid(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        BlockEntity tileEntity = (BlockEntity)context.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (!(tileEntity instanceof TileEntityTank)) {
            return stack;
        }
        TileEntityTank tank = (TileEntityTank)tileEntity;
        FluidStack fluid = tank.getFluid();
        if (fluid.isEmpty()) {
            return stack;
        }
        stack.set(CarMod.FLUID_STACK_DATA_COMPONENT, (Object)SimpleFluidContent.copyOf((FluidStack)fluid));
        return stack;
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)CarMod.COPY_FLUID.get();
    }
}

