/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageCarHorn
implements Message<MessageCarHorn> {
    public static final CustomPacketPayload.Type<MessageCarHorn> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"car_horn"));
    private boolean pressed;
    private UUID uuid;

    public MessageCarHorn() {
    }

    public MessageCarHorn(boolean pressed, Player player) {
        this.pressed = pressed;
        this.uuid = player.getUUID();
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        if (!this.pressed) {
            return;
        }
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        if (!sender.getUUID().equals(this.uuid)) {
            CarMod.LOGGER.error("The UUID of the sender was not equal to the packet UUID");
            return;
        }
        Entity entity = sender.getVehicle();
        if (!(entity instanceof EntityCarBase)) {
            return;
        }
        EntityCarBase car = (EntityCarBase)entity;
        if (sender.equals((Object)car.getDriver())) {
            car.onHornPressed((Player)sender);
        }
    }

    @Override
    public MessageCarHorn fromBytes(RegistryFriendlyByteBuf buf) {
        this.pressed = buf.readBoolean();
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.pressed);
        buf.writeUUID(this.uuid);
    }

    @Override
    public CustomPacketPayload.Type<MessageCarHorn> type() {
        return TYPE;
    }
}

