/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.net.MessageCenterCarClient;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageCenterCar
implements Message<MessageCenterCar> {
    public static final CustomPacketPayload.Type<MessageCenterCar> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"center_car"));
    private UUID uuid;

    public MessageCenterCar() {
    }

    public MessageCenterCar(Player player) {
        this.uuid = player.getUUID();
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        if (!sender.getUUID().equals(this.uuid)) {
            CarMod.LOGGER.error("The UUID of the sender was not equal to the packet UUID");
            return;
        }
        Entity entity = sender.getVehicle();
        if (!(entity instanceof EntityCarBatteryBase)) {
            return;
        }
        EntityCarBatteryBase car = (EntityCarBatteryBase)entity;
        if (sender.equals((Object)car.getDriver())) {
            car.centerCar();
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)car, (CustomPacketPayload)new MessageCenterCarClient(this.uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public MessageCenterCar fromBytes(RegistryFriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }

    @Override
    public CustomPacketPayload.Type<MessageCenterCar> type() {
        return TYPE;
    }
}

