/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.corelib.net.Message;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageRepairCar
implements Message<MessageRepairCar> {
    public static final CustomPacketPayload.Type<MessageRepairCar> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"repair_car"));
    private BlockPos pos;
    private UUID uuid;

    public MessageRepairCar() {
    }

    public MessageRepairCar(BlockPos pos, Player player) {
        this.pos = pos;
        this.uuid = player.getUUID();
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.SERVERBOUND;
    }

    @Override
    public void executeServerSide(IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sender = (ServerPlayer)player;
        if (!sender.getUUID().equals(this.uuid)) {
            CarMod.LOGGER.error("The UUID of the sender was not equal to the packet UUID");
            return;
        }
        BlockEntity blockEntity = sender.level().getBlockEntity(this.pos);
        if (blockEntity instanceof TileEntityCarWorkshop) {
            TileEntityCarWorkshop workshop = (TileEntityCarWorkshop)blockEntity;
            workshop.repairCar(sender);
        }
    }

    @Override
    public MessageRepairCar fromBytes(RegistryFriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeUUID(this.uuid);
    }

    @Override
    public CustomPacketPayload.Type<MessageRepairCar> type() {
        return TYPE;
    }
}

