/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.net.ClientNetworking;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageSyncTileEntity
implements Message<MessageSyncTileEntity> {
    public static final CustomPacketPayload.Type<MessageSyncTileEntity> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"sync_block_entity"));
    private BlockPos pos;
    private CompoundTag tag;

    public MessageSyncTileEntity() {
    }

    public MessageSyncTileEntity(BlockPos pos, CompoundTag tileTag) {
        this.pos = pos;
        this.tag = tileTag;
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public void executeClientSide(IPayloadContext context) {
        ClientNetworking.syncTileEntity(this.pos, this.tag);
    }

    @Override
    public MessageSyncTileEntity fromBytes(RegistryFriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.tag = buf.readNbt();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeNbt((Tag)this.tag);
    }

    @Override
    public CustomPacketPayload.Type<MessageSyncTileEntity> type() {
        return TYPE;
    }
}

