/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.recipes;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public abstract class EnergyFluidProducerRecipe
implements Recipe<RecipeInput> {
    protected final RecipeType<? extends Recipe<RecipeInput>> type;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final String group;
    protected final int fluidAmount;
    protected final int energy;
    protected final int duration;

    public EnergyFluidProducerRecipe(RecipeType<? extends Recipe<RecipeInput>> type, String group, Ingredient ingredientIn, ItemStack result, int fluidAmount, int energy, int duration) {
        this.type = type;
        this.group = group;
        this.ingredient = ingredientIn;
        this.result = result;
        this.fluidAmount = fluidAmount;
        this.energy = energy;
        this.duration = duration;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        return this.ingredient.test(inv.getItem(0));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean isSpecial() {
        return false;
    }

    public ItemStack getResultItem() {
        return this.result.copy();
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getDuration() {
        return this.duration;
    }

    public RecipeType<? extends Recipe<RecipeInput>> getType() {
        return this.type;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.create((Ingredient)this.ingredient);
    }

    public RecipeBookCategory recipeBookCategory() {
        return null;
    }
}

