/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.recipes;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.items.ModItems;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class KeyRecipe
extends CustomRecipe {
    public KeyRecipe(CraftingBookCategory category) {
        super(category);
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)CarMod.CRAFTING_SPECIAL_KEY.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList list = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.getItem().equals(ModItems.KEY.get())) continue;
            list.set(i, (Object)stack.copy());
        }
        return list;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        return this.assemble(inv) != null;
    }

    public ItemStack assemble(CraftingInput craftingContainer, HolderLookup.Provider provider) {
        return this.assemble(craftingContainer);
    }

    public ItemStack assemble(CraftingInput inv) {
        ItemStack key = null;
        ItemStack iron = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem().equals(ModItems.KEY.get())) {
                if (key != null) {
                    return null;
                }
                key = stack;
                continue;
            }
            if (!stack.getItem().equals(Items.IRON_INGOT)) continue;
            if (iron != null) {
                return null;
            }
            iron = stack;
        }
        if (key == null || iron == null) {
            return null;
        }
        UUID uuid = ItemKey.getCar(key);
        if (uuid == null) {
            return new ItemStack((ItemLike)ModItems.KEY.get());
        }
        ItemStack out = ItemKey.getKeyForCar(uuid);
        return out;
    }
}

