/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.car.recipes.EnergyFluidProducerRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public abstract class RecipeSerializerEnergyFluidProducer<T extends EnergyFluidProducerRecipe>
implements RecipeSerializer<T> {
    private final IFactory<T> factory;
    private MapCodec<T> codec;
    private StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public RecipeSerializerEnergyFluidProducer(IFactory<T> factory) {
        this.factory = factory;
        this.codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)BuiltInRegistries.ITEM.byNameCodec().xmap(ItemStack::new, ItemStack::getItem).fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("fluidamount").forGetter(recipe -> recipe.fluidAmount), (App)Codec.INT.fieldOf("energy").forGetter(recipe -> recipe.energy), (App)Codec.INT.fieldOf("duration").forGetter(recipe -> recipe.duration)).apply((Applicative)builder, factory::create));
        this.streamCodec = StreamCodec.of(this::toNetwork, this::fromNetwork);
    }

    public MapCodec<T> codec() {
        return this.codec;
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    public T fromNetwork(RegistryFriendlyByteBuf buffer) {
        return this.factory.create(buffer.readUtf(Short.MAX_VALUE), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readVarInt(), buffer.readVarInt(), buffer.readVarInt());
    }

    public void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
        buffer.writeUtf(((EnergyFluidProducerRecipe)recipe).group);
        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((EnergyFluidProducerRecipe)recipe).ingredient);
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((EnergyFluidProducerRecipe)recipe).result);
        buffer.writeVarInt(((EnergyFluidProducerRecipe)recipe).fluidAmount);
        buffer.writeVarInt(((EnergyFluidProducerRecipe)recipe).energy);
        buffer.writeVarInt(((EnergyFluidProducerRecipe)recipe).duration);
    }

    public static interface IFactory<T extends EnergyFluidProducerRecipe> {
        public T create(String var1, Ingredient var2, ItemStack var3, int var4, int var5, int var6);
    }
}

