/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.sounds;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public abstract class SoundLoopCar
extends AbstractTickableSoundInstance {
    protected EntityCarBase car;

    public SoundLoopCar(EntityCarBase car, SoundEvent event, SoundSource category) {
        super(event, category, SoundInstance.createUnseededRandom());
        this.car = car;
        this.looping = true;
        this.delay = 0;
        this.volume = ((Double)CarMod.CLIENT_CONFIG.carVolume.get()).floatValue();
        this.pitch = 1.0f;
        this.relative = false;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.updatePos();
    }

    public void updatePos() {
        this.x = (float)this.car.getX();
        this.y = (float)this.car.getY();
        this.z = (float)this.car.getZ();
    }

    public void tick() {
        if (this.isStopped()) {
            return;
        }
        if (!this.car.isAlive()) {
            this.setDonePlaying();
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !player.isAlive()) {
            this.setDonePlaying();
            return;
        }
        if (this.shouldStopSound()) {
            this.setDonePlaying();
            return;
        }
        this.updatePos();
    }

    public void setDonePlaying() {
        this.stop();
    }

    public abstract boolean shouldStopSound();
}

