/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.villagers;

import de.maxhenkel.car.CarMod;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.items.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

public class VillagerEvents {
    @SubscribeEvent
    public void villagerTrades(VillagerTradesEvent event) {
        if (event.getType().equals(CarMod.VILLAGER_PROFESSION_GAS_STATION_ATTENDANT.get())) {
            event.getTrades().put(1, new ArrayList<Trade>(Arrays.asList(new EmeraldForItemsTrade((ItemLike)ModItems.CANOLA.get(), 20, 16, 2), new Trade((ItemLike)Items.EMERALD, 16, (ItemLike)ModBlocks.ASPHALT.get(), 4, 16, 2))));
            event.getTrades().put(2, new ArrayList<MultiTrade>(Arrays.asList(new MultiTrade(new Trade((ItemLike)Items.EMERALD, 8, (ItemLike)ModItems.PAINTER.get(), 1, 8, 3), new Trade((ItemLike)Items.EMERALD, 8, (ItemLike)ModItems.PAINTER_YELLOW.get(), 1, 8, 3)), new MultiTrade(new Trade((ItemLike)Items.EMERALD, 16, (ItemLike)ModItems.WRENCH.get(), 1, 3, 6), new Trade((ItemLike)Items.EMERALD, 16, (ItemLike)ModItems.SCREW_DRIVER.get(), 1, 3, 6), new Trade((ItemLike)Items.EMERALD, 16, (ItemLike)ModItems.HAMMER.get(), 1, 3, 6)))));
            event.getTrades().put(3, new ArrayList<Trade>(Arrays.asList(new Trade((ItemLike)Items.EMERALD, 18, (ItemLike)ModItems.CANISTER.get(), 1, 3, 8), new Trade((ItemLike)Items.EMERALD, 24, (ItemLike)ModItems.REPAIR_KIT.get(), 1, 3, 8))));
            event.getTrades().put(4, new ArrayList<MultiTrade>(Arrays.asList(new MultiTrade(new Trade((ItemLike)Items.EMERALD, 32, (ItemLike)ModItems.BATTERY.get(), 1, 3, 12), new Trade((ItemLike)Items.EMERALD, 32, (ItemLike)ModItems.LICENSE_PLATE.get(), 1, 3, 12)))));
        }
    }

    static class Trade
    implements VillagerTrades.ItemListing {
        private final Item buyingItem;
        private final Item sellingItem;
        private final int buyingAmount;
        private final int sellingAmount;
        private final int maxUses;
        private final int givenExp;
        private final float priceMultiplier;

        public Trade(ItemLike buyingItem, int buyingAmount, ItemLike sellingItem, int sellingAmount, int maxUses, int givenExp) {
            this.buyingItem = buyingItem.asItem();
            this.buyingAmount = buyingAmount;
            this.sellingItem = sellingItem.asItem();
            this.sellingAmount = sellingAmount;
            this.maxUses = maxUses;
            this.givenExp = givenExp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemCost((ItemLike)this.buyingItem, this.buyingAmount), new ItemStack((ItemLike)this.sellingItem, this.sellingAmount), this.maxUses, this.givenExp, this.priceMultiplier);
        }
    }

    static class EmeraldForItemsTrade
    extends Trade {
        public EmeraldForItemsTrade(ItemLike buyingItem, int buyingAmount, int maxUses, int givenExp) {
            super(buyingItem, buyingAmount, (ItemLike)Items.EMERALD, 1, maxUses, givenExp);
        }
    }

    static class MultiTrade
    implements VillagerTrades.ItemListing {
        private final VillagerTrades.ItemListing[] trades;

        public MultiTrade(VillagerTrades.ItemListing ... trades) {
            this.trades = trades;
        }

        @Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource random) {
            return this.trades[random.nextInt(this.trades.length)].getOffer(entity, random);
        }
    }
}

