/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import com.mojang.math.Axis;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityTools {
    @Nullable
    public static EntityGenericCar getCarByUUID(Player player, UUID uuid) {
        double distance = 10.0;
        return player.level().getEntitiesOfClass(EntityGenericCar.class, new AABB(player.getX() - distance, player.getY() - distance, player.getZ() - distance, player.getX() + distance, player.getY() + distance, player.getZ() + distance), entity -> entity.getUUID().equals(uuid)).stream().findAny().orElse(null);
    }

    public static void drawCarOnScreen(GuiGraphics graphics, EntityGenericCar car, int x1, int y1, int x2, int y2, float scale, float rotation) {
        float ySize = y2 - y1;
        float yOffset = ySize / 2.0f / scale;
        EntityTools.renderEntityInInventory(graphics, x1, y1, x2, y2, scale, new Vector3f(0.0f, yOffset, 0.0f), Axis.YP.rotationDegrees(135.0f + rotation).mul((Quaternionfc)Axis.ZP.rotationDegrees(180.0f)), car);
    }

    public static void renderEntityInInventory(GuiGraphics guiGraphics, int x1, int y1, int x2, int y2, float scale, Vector3f translation, Quaternionf rotation, Entity entity) {
        EntityRenderDispatcher entityrenderdispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityrenderer = entityrenderdispatcher.getRenderer(entity);
        EntityRenderState entityrenderstate = entityrenderer.createRenderState(entity, 1.0f);
        entityrenderstate.lightCoords = 0xF000F0;
        entityrenderstate.hitboxesRenderState = null;
        entityrenderstate.shadowPieces.clear();
        entityrenderstate.outlineColor = 0;
        guiGraphics.submitEntityRenderState(entityrenderstate, scale, translation, rotation, null, x1, y1, x2, y2);
    }

    public static interface Renderer {
        public void render(float var1);

        public void tick();
    }

    public static class SimulatedTicker {
        private static final long ONE_TICK = 50000000L;
        private long lastTick;

        public void render(Renderer renderer) {
            long currentNanos = System.nanoTime();
            if (currentNanos - this.lastTick >= 50000000L) {
                renderer.tick();
                this.lastTick = currentNanos;
            }
            renderer.render((float)(currentNanos - this.lastTick) / 5.0E7f);
        }
    }

    public static class SimulatedCarRenderer {
        private float rotation;
        private final float rotationPerTick;
        private final SimulatedTicker ticker;

        public SimulatedCarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.ticker = new SimulatedTicker();
        }

        public SimulatedCarRenderer() {
            this(3.6f);
        }

        public void render(final GuiGraphics guiGraphics, final EntityGenericCar car, final int x1, final int y1, final int x2, final int y2, final int scale) {
            this.ticker.render(new Renderer(){

                @Override
                public void render(float partialTicks) {
                    EntityTools.drawCarOnScreen(guiGraphics, car, x1, y1, x2, y2, scale, rotation + rotationPerTick * partialTicks);
                }

                @Override
                public void tick() {
                    rotation += rotationPerTick;
                    if (rotation >= 360.0f) {
                        rotation = 0.0f;
                    }
                }
            });
        }
    }

    public static class CarRenderer {
        private float rotation;
        private final float rotationPerTick;
        private final Minecraft minecraft;

        public CarRenderer(float rotationPerTick) {
            this.rotationPerTick = rotationPerTick;
            this.minecraft = Minecraft.getInstance();
        }

        public CarRenderer() {
            this(3.6f);
        }

        public void tick() {
            this.rotation += this.rotationPerTick;
            if (this.rotation >= 360.0f) {
                this.rotation = 0.0f;
            }
        }

        public void render(GuiGraphics guiGraphics, EntityGenericCar car, int x1, int y1, int x2, int y2, int scale) {
            EntityTools.drawCarOnScreen(guiGraphics, car, x1, y1, x2, y2, scale, this.rotation + this.rotationPerTick * this.minecraft.getDeltaTracker().getRealtimeDeltaTicks());
        }
    }
}

