/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tools;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.access.ItemAccess;

public class FluidInteractionTools {
    public static boolean tryFluidInteraction(Player player, InteractionHand hand, Level level, BlockPos pos) {
        ResourceHandler blockCapability = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, pos, null);
        ItemAccess itemAccess = ItemAccess.forPlayerInteraction((Player)player, (InteractionHand)hand);
        ResourceHandler itemCapability = (ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM);
        if (itemCapability != null) {
            int moved = ResourceHandlerUtil.move((ResourceHandler)itemCapability, (ResourceHandler)blockCapability, resource -> true, (int)Integer.MAX_VALUE, null);
            if (moved > 0) {
                player.playSound(SoundEvents.BUCKET_EMPTY, 1.0f, 1.0f);
                return true;
            }
            moved = ResourceHandlerUtil.move((ResourceHandler)blockCapability, (ResourceHandler)itemCapability, resource -> true, (int)Integer.MAX_VALUE, null);
            if (moved > 0) {
                player.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
                return true;
            }
        }
        return false;
    }
}

