/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemCanister
extends Item {
    public ItemCanister() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43723_().m_6144_()) {
            return super.m_6225_(context);
        }
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        BlockEntity te = state.m_60734_().equals(ModBlocks.GAS_STATION_TOP.get()) ? context.m_43725_().m_7702_(context.m_8083_().m_7495_()) : context.m_43725_().m_7702_(context.m_8083_());
        if (te == null) {
            return super.m_6225_(context);
        }
        if (te instanceof TileEntityGasStation) {
            TileEntityGasStation gasStation = (TileEntityGasStation)te;
            if (gasStation.hasTrade()) {
                return super.m_6225_(context);
            }
            boolean success = ItemCanister.fillCanister(context.m_43723_().m_21120_(context.m_43724_()), gasStation);
            if (success) {
                ModSounds.playSound(SoundEvents.f_11772_, context.m_43725_(), context.m_8083_(), null, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        if (te instanceof IFluidHandler) {
            IFluidHandler handler = (IFluidHandler)te;
            boolean success = ItemCanister.fuelFluidHandler(context.m_43723_().m_21120_(context.m_43724_()), handler);
            if (success) {
                ModSounds.playSound(SoundEvents.f_11772_, context.m_43725_(), context.m_8083_(), null, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            CompoundTag comp = stack.m_41783_();
            if (comp.m_128441_("fuel")) {
                CompoundTag fuel = comp.m_128469_("fuel");
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)fuel);
                if (fluidStack == null || fluidStack.isEmpty()) {
                    this.addInfo("-", 0, tooltip);
                    super.m_7373_(stack, worldIn, tooltip, flagIn);
                    return;
                }
                this.addInfo(fluidStack.getDisplayName().getString(), fluidStack.getAmount(), tooltip);
                super.m_7373_(stack, worldIn, tooltip, flagIn);
                return;
            }
            this.addInfo("-", 0, tooltip);
            super.m_7373_(stack, worldIn, tooltip, flagIn);
            return;
        }
        this.addInfo("-", 0, tooltip);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    private void addInfo(String fluid, int amount, List<Component> tooltip) {
        tooltip.add((Component)Component.m_237110_((String)"canister.fluid", (Object[])new Object[]{Component.m_237113_((String)fluid).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"canister.amount", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(amount)).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
    }

    public static boolean fillCanister(ItemStack canister, IFluidHandler handler) {
        CompoundTag comp = canister.m_41784_();
        FluidStack fluid = null;
        if (comp.m_128441_("fuel")) {
            fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)comp.m_128469_("fuel"));
        }
        int maxAmount = (Integer)Main.SERVER_CONFIG.canisterMaxFuel.get();
        if (fluid != null) {
            maxAmount = (Integer)Main.SERVER_CONFIG.canisterMaxFuel.get() - fluid.getAmount();
        }
        if (maxAmount <= 0) {
            return false;
        }
        FluidStack resultSim = handler.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE);
        if (resultSim.getAmount() <= 0) {
            return false;
        }
        if (fluid != null && !fluid.isEmpty() && !resultSim.getFluid().equals(fluid.getFluid())) {
            return false;
        }
        FluidStack result = handler.drain(maxAmount, IFluidHandler.FluidAction.EXECUTE);
        if (result.isEmpty()) {
            return false;
        }
        if (fluid == null || fluid.isEmpty()) {
            comp.m_128365_("fuel", (Tag)result.writeToNBT(new CompoundTag()));
            return true;
        }
        if (result.getFluid().equals(fluid.getFluid())) {
            fluid.setAmount(fluid.getAmount() + result.getAmount());
            comp.m_128365_("fuel", (Tag)fluid.writeToNBT(new CompoundTag()));
        }
        return true;
    }

    public static boolean fuelFluidHandler(ItemStack canister, IFluidHandler handler) {
        if (!canister.m_41782_()) {
            return false;
        }
        CompoundTag comp = canister.m_41783_();
        if (!comp.m_128441_("fuel")) {
            return false;
        }
        CompoundTag fluid = comp.m_128469_("fuel");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)fluid);
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        int fueledAmount = handler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        stack.setAmount(stack.getAmount() - fueledAmount);
        if (stack.getAmount() <= 0) {
            comp.m_128365_("fuel", (Tag)new CompoundTag());
            return true;
        }
        CompoundTag f = new CompoundTag();
        stack.writeToNBT(f);
        comp.m_128365_("fuel", (Tag)f);
        return true;
    }
}

