/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.generator.instances;

import de.xtkq.voidgen.generator.annotations.VoidChunkGenInfo;
import de.xtkq.voidgen.generator.interfaces.ChunkGen;
import de.xtkq.voidgen.generator.settings.LayerSettings;
import de.xtkq.voidgen.utils.VoidBiomeProvider;
import java.util.Random;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@VoidChunkGenInfo(versions={"1.21.3", "1.21.4", "1.21.5", "1.21.6", "1.21.7", "1.21.8", "1.21.9", "1.21.10", "1.21.11"})
public final class VoidChunkGen_1_21_3
extends ChunkGen {
    public VoidChunkGen_1_21_3(JavaPlugin javaPlugin, String paramIdentifier, String worldName) {
        super(javaPlugin, paramIdentifier, worldName);
    }

    @Override
    public Biome getDefaultBiome() {
        return Biome.THE_VOID;
    }

    public BiomeProvider getDefaultBiomeProvider(@NotNull WorldInfo worldInfo) {
        return this.chunkGenSettings.getBiome().map(biome -> new VoidBiomeProvider((Biome)biome)).orElse(super.getDefaultBiomeProvider(worldInfo));
    }

    @NotNull
    public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.BiomeGrid paramBiomeGrid) {
        ChunkGenerator.ChunkData chunkData = this.createChunkData(world);
        int yOffset = world.getMinHeight();
        if (this.chunkGenSettings.getLayers().isPresent()) {
            for (LayerSettings layer : this.chunkGenSettings.getLayers().get()) {
                for (int y = 0; y < layer.getHeight(); ++y) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            chunkData.setBlock(x, yOffset, z, layer.composeBlockData());
                        }
                    }
                    ++yOffset;
                }
            }
        } else if (this.chunkGenSettings.getBedrock().orElse(false).booleanValue()) {
            super.generateBedrock((WorldInfo)world, random, chunkX, chunkZ, chunkData);
        }
        return chunkData;
    }
}

