/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.generator.interfaces;

import de.xtkq.voidgen.generator.settings.ChunkGenSettings;
import de.xtkq.voidgen.libs.gson.Gson;
import de.xtkq.voidgen.libs.gson.GsonBuilder;
import de.xtkq.voidgen.libs.gson.JsonSyntaxException;
import de.xtkq.voidgen.libs.gson.Strictness;
import de.xtkq.voidgen.settings.Settings;
import de.xtkq.voidgen.utils.ChunkGenAdapter;
import java.lang.reflect.Type;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class ChunkGen
extends ChunkGenerator {
    private final JavaPlugin javaPlugin;
    protected ChunkGenSettings chunkGenSettings;

    public ChunkGen(JavaPlugin javaPlugin, String paramIdentifier, String worldName) {
        Gson gson;
        block8: {
            this.javaPlugin = javaPlugin;
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeAdapter((Type)((Object)ChunkGenSettings.class), new ChunkGenAdapter(this.javaPlugin));
            builder.setStrictness(Strictness.LENIENT);
            gson = builder.create();
            if (((Boolean)Settings.ENABLE_VERBOSE.get()).booleanValue()) {
                this.javaPlugin.getLogger().info("");
                this.javaPlugin.getLogger().info("> \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014[ " + worldName + " ]\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
                this.javaPlugin.getLogger().info("> ");
            }
            if (paramIdentifier == null || paramIdentifier.isBlank()) {
                this.chunkGenSettings = new ChunkGenSettings().setBiome(this.getDefaultBiome());
                if (((Boolean)Settings.ENABLE_VERBOSE.get()).booleanValue()) {
                    this.javaPlugin.getLogger().info("> Generator settings have not been set, we will use the default settings:");
                }
            } else {
                try {
                    this.chunkGenSettings = gson.fromJson(paramIdentifier, ChunkGenSettings.class);
                    if (((Boolean)Settings.ENABLE_VERBOSE.get()).booleanValue()) {
                        this.javaPlugin.getLogger().info("> Generator settings have been loaded:");
                    }
                }
                catch (JsonSyntaxException jse) {
                    this.chunkGenSettings = new ChunkGenSettings().setBiome(this.getDefaultBiome());
                    if (!((Boolean)Settings.ENABLE_VERBOSE.get()).booleanValue()) break block8;
                    this.javaPlugin.getLogger().info("> Generator settings syntax is not valid, we will use the default settings:");
                }
            }
        }
        if (((Boolean)Settings.ENABLE_VERBOSE.get()).booleanValue()) {
            this.javaPlugin.getLogger().info("> " + gson.toJson(this.chunkGenSettings));
            this.javaPlugin.getLogger().info("> ");
            this.javaPlugin.getLogger().info("> \u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014[ " + worldName + " ]\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014");
            this.javaPlugin.getLogger().info("");
        }
    }

    public abstract Biome getDefaultBiome();

    public Location getFixedSpawnLocation(@NotNull World world, @NotNull Random random) {
        return new Location(world, 0.0, 64.0, 0.0);
    }

    public boolean shouldGenerateCaves() {
        return this.chunkGenSettings.getCaves().orElse(false);
    }

    public boolean shouldGenerateDecorations() {
        return this.chunkGenSettings.getDecoration().orElse(false);
    }

    public boolean shouldGenerateMobs() {
        return this.chunkGenSettings.getMobs().orElse(false);
    }

    public boolean shouldGenerateStructures() {
        return this.chunkGenSettings.getStructures().orElse(false);
    }

    public boolean shouldGenerateNoise() {
        return this.chunkGenSettings.getNoise().orElse(false);
    }

    public boolean shouldGenerateSurface() {
        return this.chunkGenSettings.getSurface().orElse(false);
    }

    public boolean shouldGenerateBedrock() {
        return this.chunkGenSettings.getBedrock().orElse(false);
    }

    public void generateBedrock(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        boolean x = false;
        int y = 64;
        boolean z = false;
        if (0 >= chunkX * 16 && 0 < (chunkX + 1) * 16 && 0 >= chunkZ * 16 && 0 < (chunkZ + 1) * 16) {
            chunkData.setBlock(0, 64, 0, Material.BEDROCK);
        }
    }
}

