/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.settings;

import java.util.List;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;

public abstract class Setting<T> {
    protected T value;
    protected final String key;
    protected final T defaultValue;
    protected final List<String> comments;
    protected final List<String> inlineComments;

    protected Setting(String key, T defaultValue, List<String> comments, List<String> inlineComments) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.comments = comments;
        this.inlineComments = inlineComments;
    }

    protected void setup(ConfigurationSection section) {
        section.set(this.key, this.defaultValue);
        if (!this.comments.isEmpty()) {
            section.setComments(this.key, this.comments);
        }
        if (!this.inlineComments.isEmpty()) {
            section.setInlineComments(this.key, this.inlineComments);
        }
        this.value = this.defaultValue;
    }

    public abstract Setting<T> load(ConfigurationSection var1, boolean var2, Logger var3);

    public T get() {
        return this.value;
    }

    public Setting<T> set(T value) {
        this.value = value;
        return this;
    }
}

