/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.settings.impl;

import de.xtkq.voidgen.settings.Setting;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;

public class BooleanSetting
extends Setting<Boolean> {
    public BooleanSetting(String value, Boolean defaultValue, List<String> comments, List<String> inlineComments) {
        super(value, defaultValue, comments, inlineComments);
    }

    public BooleanSetting(String value, Boolean defaultValue, List<String> comments) {
        super(value, defaultValue, comments, List.of());
    }

    public BooleanSetting(String value, Boolean defaultValue) {
        super(value, defaultValue, List.of(), List.of());
    }

    public final BooleanSetting load(ConfigurationSection section, boolean firstTime, Logger logger) {
        if (section.isBoolean(this.key)) {
            this.value = section.getBoolean(this.key);
        } else if (section.isString(this.key)) {
            String str = section.getString(this.key, (Boolean)this.defaultValue != false ? "yes" : "no");
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
                this.value = Boolean.parseBoolean(str);
            } else if (str.equalsIgnoreCase("yes")) {
                this.value = true;
            } else if (str.equalsIgnoreCase("no")) {
                this.value = false;
            } else {
                this.setup(section);
            }
        } else {
            if (!firstTime) {
                logger.info("Boolean at key: " + section.getCurrentPath() + this.key + " doesn't exists, creating...");
            }
            this.setup(section);
        }
        return this;
    }

    @Override
    protected void setup(ConfigurationSection section) {
        section.set(this.key, (Object)((Boolean)this.defaultValue != false ? "yes" : "no"));
        if (!this.comments.isEmpty()) {
            section.setComments(this.key, this.comments);
        }
        if (!this.inlineComments.isEmpty()) {
            section.setInlineComments(this.key, this.inlineComments);
        }
        this.value = this.defaultValue;
    }
}

