/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.settings.impl;

import de.xtkq.voidgen.settings.Setting;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;

public class IntegerSetting
extends Setting<Integer> {
    private final int min;
    private final int max;

    public IntegerSetting(String value, Integer defaultValue, List<String> comments, List<String> inlineComments, int min, int max) {
        super(value, defaultValue, comments, inlineComments);
        this.min = min;
        this.max = max;
    }

    public IntegerSetting(String value, Integer defaultValue, List<String> comments, List<String> inlineComments, int min) {
        this(value, defaultValue, comments, inlineComments, min, Integer.MAX_VALUE);
    }

    public IntegerSetting(String value, Integer defaultValue, List<String> comments, List<String> inlineComments) {
        this(value, defaultValue, comments, inlineComments, Integer.MIN_VALUE);
    }

    public IntegerSetting(String value, Integer defaultValue, List<String> comments, int min, int max) {
        this(value, defaultValue, comments, List.of(), min, max);
    }

    public IntegerSetting(String value, Integer defaultValue, List<String> comments, int min) {
        this(value, defaultValue, comments, List.of(), min);
    }

    public IntegerSetting(String value, Integer defaultValue, List<String> comments) {
        this(value, defaultValue, comments, List.of());
    }

    public IntegerSetting(String value, Integer defaultValue, int min, int max) {
        this(value, defaultValue, List.of(), min, max);
    }

    public IntegerSetting(String value, Integer defaultValue, int min) {
        this(value, defaultValue, List.of(), min);
    }

    public IntegerSetting(String value, Integer defaultValue) {
        this(value, defaultValue, List.of());
    }

    public final IntegerSetting load(ConfigurationSection section, boolean firstTime, Logger logger) {
        if (section.isInt(this.key)) {
            this.value = section.getInt(this.key, ((Integer)this.defaultValue).intValue());
        } else {
            if (!firstTime) {
                logger.info("Integer at key: " + section.getCurrentPath() + this.key + " doesn't exists, creating...");
            }
            super.setup(section);
        }
        if ((Integer)this.value < this.min) {
            logger.info("Value for integer at key: " + section.getCurrentPath() + this.key + " is too small! Setting to the minimum value: " + this.min);
            this.value = this.min;
            section.set(this.key, this.value);
        } else if ((Integer)this.value > this.max) {
            logger.info("Value for integer at key: " + section.getCurrentPath() + this.key + " is too big! Setting to the maximum value: " + this.max);
            this.value = this.max;
            section.set(this.key, this.value);
        }
        return this;
    }
}

