/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.settings.impl;

import de.xtkq.voidgen.settings.Setting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;

public class MappedStringSetting
extends Setting<Map<String, String>> {
    public MappedStringSetting(String key, Map<String, String> defaultValue, List<String> comments, List<String> inlineComments) {
        super(key, defaultValue, comments, inlineComments);
    }

    public MappedStringSetting(String key, Map<String, String> defaultValue, List<String> comments) {
        super(key, defaultValue, comments, List.of());
    }

    public MappedStringSetting(String key, Map<String, String> defaultValue) {
        super(key, defaultValue, List.of(), List.of());
    }

    public final MappedStringSetting load(ConfigurationSection section, boolean firstTime, Logger logger) {
        ConfigurationSection upperSection = section.getConfigurationSection(this.key);
        if (upperSection != null) {
            this.value = new HashMap();
            for (String key : upperSection.getKeys(false)) {
                if (!upperSection.isString(key)) continue;
                ((Map)this.value).put(key, upperSection.getString(key));
            }
        } else {
            if (!firstTime) {
                logger.info("Mapped strings at key: " + section.getCurrentPath() + this.key + " doesn't exists, creating...");
            }
            this.setup(section);
        }
        return this;
    }

    @Override
    protected void setup(ConfigurationSection section) {
        ConfigurationSection upperSection = section.createSection(this.key);
        for (Map.Entry entry : ((Map)this.defaultValue).entrySet()) {
            upperSection.set((String)entry.getKey(), entry.getValue());
        }
        this.value = this.defaultValue;
        if (!this.comments.isEmpty()) {
            upperSection.setComments(this.key, this.comments);
        }
        if (!this.inlineComments.isEmpty()) {
            upperSection.setInlineComments(this.key, this.inlineComments);
        }
    }
}

