/*
 * Decompiled with CFR 0.152.
 */
package de.xtkq.voidgen.utils;

import de.xtkq.voidgen.generator.settings.ChunkGenSettings;
import de.xtkq.voidgen.generator.settings.LayerSettings;
import de.xtkq.voidgen.libs.gson.TypeAdapter;
import de.xtkq.voidgen.libs.gson.stream.JsonReader;
import de.xtkq.voidgen.libs.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.block.Biome;
import org.bukkit.plugin.java.JavaPlugin;

public class ChunkGenAdapter
extends TypeAdapter<ChunkGenSettings> {
    private final JavaPlugin javaPlugin;

    public ChunkGenAdapter(JavaPlugin paramPlugin) {
        this.javaPlugin = paramPlugin;
    }

    @Override
    public void write(JsonWriter jsonWriter, ChunkGenSettings chunkGenSettings) throws IOException {
        jsonWriter.beginObject();
        if (chunkGenSettings.getBiome().isPresent()) {
            jsonWriter.name("biome").value(chunkGenSettings.getBiome().get().name().toLowerCase());
        }
        if (chunkGenSettings.getCaves().isPresent()) {
            jsonWriter.name("caves").value(chunkGenSettings.getCaves().get());
        }
        if (chunkGenSettings.getDecoration().isPresent()) {
            jsonWriter.name("decoration").value(chunkGenSettings.getDecoration().get());
        }
        if (chunkGenSettings.getMobs().isPresent()) {
            jsonWriter.name("mobs").value(chunkGenSettings.getMobs().get());
        }
        if (chunkGenSettings.getStructures().isPresent()) {
            jsonWriter.name("structures").value(chunkGenSettings.getStructures().get());
        }
        if (chunkGenSettings.getNoise().isPresent()) {
            jsonWriter.name("noise").value(chunkGenSettings.getNoise().get());
        }
        if (chunkGenSettings.getSurface().isPresent()) {
            jsonWriter.name("surface").value(chunkGenSettings.getSurface().get());
        }
        if (chunkGenSettings.getBedrock().isPresent()) {
            jsonWriter.name("bedrock").value(chunkGenSettings.getBedrock().get());
        }
        if (chunkGenSettings.getLayers().isPresent()) {
            jsonWriter.name("layers").beginArray();
            for (LayerSettings layerSettings : chunkGenSettings.getLayers().get()) {
                layerSettings.write(jsonWriter);
            }
            jsonWriter.endArray();
        }
        jsonWriter.endObject();
    }

    @Override
    public ChunkGenSettings read(JsonReader jsonReader) throws IOException {
        ChunkGenSettings chunkGenSettings = new ChunkGenSettings();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            switch (jsonReader.nextName()) {
                case "biome": {
                    String biomeName = jsonReader.nextString();
                    try {
                        chunkGenSettings.setBiome(Biome.valueOf((String)biomeName.toUpperCase()));
                    }
                    catch (Exception ex) {
                        this.javaPlugin.getLogger().warning("Unknown biome \"" + biomeName + "\" skipped!");
                    }
                    break;
                }
                case "caves": {
                    chunkGenSettings.setCaves(jsonReader.nextBoolean());
                    break;
                }
                case "decoration": {
                    chunkGenSettings.setDecoration(jsonReader.nextBoolean());
                    break;
                }
                case "mobs": {
                    chunkGenSettings.setMobs(jsonReader.nextBoolean());
                    break;
                }
                case "structures": {
                    chunkGenSettings.setStructures(jsonReader.nextBoolean());
                    break;
                }
                case "noise": {
                    chunkGenSettings.setNoise(jsonReader.nextBoolean());
                    break;
                }
                case "surface": {
                    chunkGenSettings.setSurface(jsonReader.nextBoolean());
                    break;
                }
                case "bedrock": {
                    chunkGenSettings.setBedrock(jsonReader.nextBoolean());
                    break;
                }
                case "layers": {
                    jsonReader.beginArray();
                    ArrayList<LayerSettings> layerSettings = new ArrayList<LayerSettings>();
                    while (jsonReader.hasNext()) {
                        layerSettings.add(new LayerSettings().read(jsonReader, this.javaPlugin.getLogger()));
                    }
                    chunkGenSettings.setLayers(layerSettings);
                    jsonReader.endArray();
                    break;
                }
                default: {
                    jsonReader.skipValue();
                }
            }
        }
        jsonReader.endObject();
        return chunkGenSettings;
    }
}

