/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.fabric;

import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.momirealms.craftengine.fabric.block.BlockManager;
import net.momirealms.craftengine.fabric.commands.CommandManager;
import net.momirealms.craftengine.fabric.config.ModConfig;
import net.momirealms.craftengine.fabric.logger.LoggerFilter;
import net.momirealms.craftengine.fabric.logger.ModLogger;
import net.momirealms.craftengine.fabric.logger.Slf4jModLogger;
import net.momirealms.craftengine.fabric.network.NetworkManager;
import net.momirealms.craftengine.fabric.util.ConfigUtils;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class CraftEngineFabricMod
implements ModInitializer {
    public static final String MOD_ID = "craftengine";
    private static CraftEngineFabricMod instance;
    private Path configPath;
    private ModLogger logger;
    private NetworkManager networkManager;
    private BlockManager blockManager;
    private CommandManager commandManager;

    public void onInitialize() {
        instance = this;
        LoggerFilter.filter();
        ConfigUtils.saveDefaultResource();
        ModConfig.INSTANCE.loadConfig();
        this.networkManager = new NetworkManager(this);
        this.blockManager = new BlockManager(this);
        this.commandManager = new CommandManager(this);
    }

    public static CraftEngineFabricMod instance() {
        return instance;
    }

    public ModLogger logger() {
        if (this.logger == null) {
            this.logger = new Slf4jModLogger(LoggerFactory.getLogger((String)MOD_ID));
        }
        return this.logger;
    }

    public Path dataFolderPath() {
        if (this.configPath == null) {
            this.configPath = FabricLoader.getInstance().getConfigDir().resolve("craft-engine-fabric-mod");
        }
        return this.configPath;
    }

    public NetworkManager networkManager() {
        if (this.networkManager == null) {
            throw new IllegalStateException("NetworkManager not initialized");
        }
        return this.networkManager;
    }

    public BlockManager blockManager() {
        if (this.blockManager == null) {
            throw new IllegalStateException("BlockManager not initialized");
        }
        return this.blockManager;
    }

    public CommandManager commandManager() {
        if (this.commandManager == null) {
            throw new IllegalStateException("CommandManager not initialized");
        }
        return this.commandManager;
    }
}

