/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.fabric.block;

import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.momirealms.craftengine.fabric.CraftEngineFabricMod;
import net.momirealms.craftengine.fabric.block.CraftEngineBlock;
import net.momirealms.craftengine.fabric.block.CraftEngineBlockState;
import net.momirealms.craftengine.fabric.config.ModConfig;
import net.momirealms.craftengine.fabric.mixin.HolderReferenceInvoker;
import net.momirealms.craftengine.fabric.util.BlockStateUtils;

@Environment(value=EnvType.CLIENT)
public class BlockManager {
    private static BlockManager instance;
    private final CraftEngineFabricMod mod;
    private final CraftEngineBlock[] customBlocks;
    private final CraftEngineBlockState[] customBlockStates;
    private final class_6880.class_6883<class_2248>[] customBlockHolders;
    private final int[] stateMappings;

    public BlockManager(CraftEngineFabricMod mod) {
        instance = this;
        this.mod = mod;
        this.customBlocks = new CraftEngineBlock[ModConfig.INSTANCE.serverSideBlocks()];
        this.customBlockStates = new CraftEngineBlockState[ModConfig.INSTANCE.serverSideBlocks()];
        this.customBlockHolders = new class_6880.class_6883[ModConfig.INSTANCE.serverSideBlocks()];
        this.initVanillaRegistry();
        this.stateMappings = new int[BlockStateUtils.vanillaStateSize() + ModConfig.INSTANCE.serverSideBlocks()];
        for (int i = 0; i < this.stateMappings.length; ++i) {
            this.stateMappings[i] = i;
        }
        this.registerServerSideCustomBlocks(ModConfig.INSTANCE.serverSideBlocks());
    }

    public static BlockManager instance() {
        return instance;
    }

    private void initVanillaRegistry() {
        int vanillaStateCount = class_2248.field_10651.method_10204();
        this.mod.logger().info("Vanilla block count: " + vanillaStateCount);
        BlockStateUtils.init(vanillaStateCount);
    }

    private void registerServerSideCustomBlocks(int count) {
        int nextStateId = BlockStateUtils.vanillaStateSize();
        for (int i = 0; i < count; ++i) {
            class_6880.class_6883 blockHolder;
            CraftEngineBlock customBlock;
            class_2960 customBlockId = class_2960.method_43902((String)"craftengine", (String)("custom_" + i));
            this.customBlocks[i] = customBlock = CraftEngineBlock.generateBlock(customBlockId);
            this.customBlockHolders[i] = blockHolder = class_2378.method_47985((class_2378)class_7923.field_41175, (class_2960)customBlockId, (Object)((Object)customBlock));
            HolderReferenceInvoker holderReferenceInvoker = (HolderReferenceInvoker)blockHolder;
            holderReferenceInvoker.callBindValue(customBlock);
            holderReferenceInvoker.tags(Set.of());
            CraftEngineBlockState newBlockState = (CraftEngineBlockState)customBlock.method_9564();
            int newBlockStateId = class_2248.field_10651.method_10206((Object)newBlockState);
            if (nextStateId != newBlockStateId) {
                class_2680 actualState = (class_2680)class_2248.field_10651.method_10200(nextStateId);
                throw new IllegalStateException("BlockState ID mismatch for " + String.valueOf((Object)newBlockState) + " (expected " + nextStateId + ", got " + newBlockStateId + ", actual state: " + String.valueOf(actualState) + ")");
            }
            this.customBlockStates[i] = newBlockState;
            ++nextStateId;
        }
        this.mod.logger().info("Registered " + count + " custom blocks.");
    }

    public CraftEngineBlock[] customBlocks() {
        return this.customBlocks;
    }

    public CraftEngineBlockState[] customBlockStates() {
        return this.customBlockStates;
    }

    public class_6880.class_6883<class_2248>[] customBlockHolders() {
        return this.customBlockHolders;
    }

    public int remapState(int state) {
        return this.stateMappings[state];
    }

    public void remapState(int state, int newState) {
        this.stateMappings[state] = newState;
    }
}

