/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.fabric.config;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.momirealms.craftengine.fabric.CraftEngineFabricMod;
import net.momirealms.craftengine.libraries.org.yaml.snakeyaml.DumperOptions;
import net.momirealms.craftengine.libraries.org.yaml.snakeyaml.Yaml;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    public static final ModConfig INSTANCE = new ModConfig();
    public static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("craft-engine-fabric-mod");
    public static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("craft-engine-fabric-mod").resolve("config.yml");
    private boolean enableNetwork = false;
    private boolean enableCancelBlockUpdate = false;
    private int serverSideBlocks = 10000;
    private boolean disableResourcePackLoadingScreen = false;

    private ModConfig() {
    }

    public boolean enableNetwork() {
        return this.enableNetwork;
    }

    public void enableNetwork(boolean enableNetwork) {
        this.enableNetwork = enableNetwork;
    }

    public boolean enableCancelBlockUpdate() {
        return this.enableCancelBlockUpdate;
    }

    public void enableCancelBlockUpdate(boolean enableCancelBlockUpdate) {
        this.enableCancelBlockUpdate = enableCancelBlockUpdate;
    }

    public int serverSideBlocks() {
        return this.serverSideBlocks;
    }

    public void serverSideBlocks(int serverSideBlocks) {
        this.serverSideBlocks = serverSideBlocks;
    }

    public boolean disableResourcePackLoadingScreen() {
        return this.disableResourcePackLoadingScreen;
    }

    public void disableResourcePackLoadingScreen(boolean disableResourcePackLoadingScreen) {
        this.disableResourcePackLoadingScreen = disableResourcePackLoadingScreen;
    }

    public void saveConfig() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        HashMap<String, Comparable<Boolean>> data = new HashMap<String, Comparable<Boolean>>();
        data.put("enable-network", Boolean.valueOf(this.enableNetwork()));
        data.put("enable-cancel-block-update", Boolean.valueOf(this.enableCancelBlockUpdate()));
        data.put("server-side-blocks", Integer.valueOf(this.serverSideBlocks()));
        data.put("disable-resource-pack-loading-screen", Boolean.valueOf(this.disableResourcePackLoadingScreen()));
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            yaml.dump(data, writer);
        }
        catch (IOException e) {
            CraftEngineFabricMod.instance().logger().warn("Failed to save config file", e);
        }
    }

    public void loadConfig() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            this.enableNetwork(false);
            this.enableCancelBlockUpdate(false);
            this.serverSideBlocks(10000);
            this.disableResourcePackLoadingScreen(false);
            return;
        }
        try (InputStream inputStream = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
            Yaml yaml = new Yaml();
            Map config = yaml.loadAs(inputStream, Map.class);
            if (config == null) {
                this.enableNetwork(false);
                this.enableCancelBlockUpdate(false);
                this.serverSideBlocks(10000);
                this.disableResourcePackLoadingScreen(false);
                return;
            }
            this.enableNetwork(config.getOrDefault("enable-network", false));
            this.enableCancelBlockUpdate(config.getOrDefault("enable-cancel-block-update", false));
            this.serverSideBlocks(config.getOrDefault("server-side-blocks", 10000));
            this.disableResourcePackLoadingScreen(config.getOrDefault("disable-resource-pack-loading-screen", false));
        }
        catch (IOException e) {
            CraftEngineFabricMod.instance().logger().severe("Failed to load config", e);
        }
    }
}

