/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.fabric.network;

import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.minecraft.class_2248;
import net.minecraft.class_2385;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_8674;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.class_9248;
import net.momirealms.craftengine.fabric.CraftEngineFabricMod;
import net.momirealms.craftengine.fabric.config.ModConfig;
import net.momirealms.craftengine.fabric.network.Context;
import net.momirealms.craftengine.fabric.network.CraftEnginePayload;
import net.momirealms.craftengine.fabric.network.ModPacket;
import net.momirealms.craftengine.fabric.network.protocol.CancelBlockUpdatePacket;
import net.momirealms.craftengine.fabric.network.protocol.ClientBlockStateSizePacket;
import net.momirealms.craftengine.fabric.network.protocol.ClientCustomBlockPacket;
import net.momirealms.craftengine.fabric.network.protocol.VisualBlockStatePacket;
import net.momirealms.craftengine.fabric.registries.BuiltInRegistries;
import net.momirealms.craftengine.fabric.util.BlockStateUtils;

@Environment(value=EnvType.CLIENT)
public class NetworkManager {
    private static NetworkManager instance;
    private final CraftEngineFabricMod mod;
    private boolean serverInstalled = false;

    public NetworkManager(CraftEngineFabricMod mod) {
        instance = this;
        this.mod = mod;
        this.registerDataTypes();
        PayloadTypeRegistry.configurationS2C().register(CraftEnginePayload.TYPE, CraftEnginePayload.CODEC);
        PayloadTypeRegistry.configurationC2S().register(CraftEnginePayload.TYPE, CraftEnginePayload.CODEC);
        ClientConfigurationNetworking.registerGlobalReceiver(CraftEnginePayload.TYPE, this::handleReceiver);
        PayloadTypeRegistry.playS2C().register(CraftEnginePayload.TYPE, CraftEnginePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(CraftEnginePayload.TYPE, CraftEnginePayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(CraftEnginePayload.TYPE, this::handleReceiver);
        ClientConfigurationConnectionEvents.START.register(this::initChannel);
        ClientPlayConnectionEvents.DISCONNECT.register((client, handler) -> this.serverInstalled(false));
    }

    public static NetworkManager instance() {
        return instance;
    }

    public boolean serverInstalled() {
        return this.serverInstalled;
    }

    public void serverInstalled(boolean serverInstalled) {
        this.serverInstalled = serverInstalled;
    }

    private void registerDataTypes() {
        NetworkManager.registerDataType(ClientCustomBlockPacket.TYPE, ClientCustomBlockPacket.CODEC);
        NetworkManager.registerDataType(CancelBlockUpdatePacket.TYPE, CancelBlockUpdatePacket.CODEC);
        NetworkManager.registerDataType(ClientBlockStateSizePacket.TYPE, ClientBlockStateSizePacket.CODEC);
        NetworkManager.registerDataType(VisualBlockStatePacket.TYPE, VisualBlockStatePacket.CODEC);
    }

    public static <T extends ModPacket> void registerDataType(class_5321<class_9139<class_2540, ? extends ModPacket>> key, class_9139<class_2540, T> codec) {
        ((class_2385)BuiltInRegistries.MOD_PACKET).method_10272(key, codec, class_9248.field_49136);
    }

    private void initChannel(class_8674 handler, class_310 client) {
        this.sendData(new ClientBlockStateSizePacket(class_2248.field_10651.method_10204()));
        if (!ModConfig.INSTANCE.enableNetwork() && !ModConfig.INSTANCE.enableCancelBlockUpdate()) {
            return;
        }
        if (ModConfig.INSTANCE.enableNetwork()) {
            this.sendData(new ClientCustomBlockPacket(BlockStateUtils.vanillaStateSize(), class_2248.field_10651.method_10204()));
        } else {
            this.sendData(new CancelBlockUpdatePacket(true));
        }
    }

    public void sendData(ModPacket data) {
        class_9139 codec = (class_9139)BuiltInRegistries.MOD_PACKET.method_29107(data.type());
        if (codec == null) {
            this.mod.logger().warn("Unknown data type class: " + data.getClass().getName());
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_52997(BuiltInRegistries.MOD_PACKET.method_10206((Object)codec));
        codec.encode((Object)buf, (Object)data);
        if (class_310.method_1551().field_1724 != null) {
            ClientPlayNetworking.send((class_8710)new CraftEnginePayload(buf.array()));
        } else if (ClientNetworkingImpl.getClientConfigurationAddon() != null) {
            ClientConfigurationNetworking.send((class_8710)new CraftEnginePayload(buf.array()));
        }
    }

    private void handleReceiver(CraftEnginePayload payload, Object context) {
        byte[] data = payload.data();
        class_2540 buf = new class_2540(Unpooled.wrappedBuffer((byte[])data));
        byte type = buf.readByte();
        class_9139 codec = (class_9139)BuiltInRegistries.MOD_PACKET.method_10200((int)type);
        if (codec == null) {
            this.mod.logger().warn("Unknown data type received: " + type);
            return;
        }
        ModPacket networkData = (ModPacket)codec.decode((Object)buf);
        networkData.handle(Context.of(context));
    }
}

