/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.fabric.network.protocol;

import io.netty.handler.codec.DecoderException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9139;
import net.momirealms.craftengine.fabric.block.BlockManager;
import net.momirealms.craftengine.fabric.block.CraftEngineBlock;
import net.momirealms.craftengine.fabric.block.CraftEngineBlockState;
import net.momirealms.craftengine.fabric.mixin.BlockBehaviourAccessor;
import net.momirealms.craftengine.fabric.mixin.BlockStateBaseAccessor;
import net.momirealms.craftengine.fabric.mixin.HolderReferenceInvoker;
import net.momirealms.craftengine.fabric.network.Context;
import net.momirealms.craftengine.fabric.network.ModPacket;
import net.momirealms.craftengine.fabric.registries.BuiltInRegistries;
import net.momirealms.craftengine.fabric.util.BlockRenderUtils;
import net.momirealms.craftengine.fabric.util.BlockStateUtils;

@Environment(value=EnvType.CLIENT)
public record VisualBlockStatePacket(int[] data) implements ModPacket
{
    public static final class_5321<class_9139<class_2540, ? extends ModPacket>> TYPE = class_5321.method_29179((class_5321)BuiltInRegistries.MOD_PACKET.method_30517(), (class_2960)class_2960.method_43902((String)"craftengine", (String)"visual_block_state"));
    public static final class_9139<class_2540, VisualBlockStatePacket> CODEC = ModPacket.codec(VisualBlockStatePacket::encode, VisualBlockStatePacket::new);
    private static final int RLE_THRESHOLD = 3;
    private static final int RLE_TAG = 0;
    private static final int DELTA_TAG = 1;
    private static VisualBlockStatePacket previousPacket;

    private VisualBlockStatePacket(class_2540 buf) {
        this(VisualBlockStatePacket.decode(buf));
        previousPacket = this;
    }

    private void encode(class_2540 buf) {
        VisualBlockStatePacket.encode(buf, this.data);
    }

    private static void encode(class_2540 buf, int[] data) {
        if (data.length == 0) {
            buf.method_10804(0);
            return;
        }
        buf.method_10804(data.length);
        int i = 0;
        int previousValue = 0;
        while (i < data.length) {
            int currentValue = data[i];
            int repeatCount = 1;
            for (int j = i + 1; j < data.length && data[j] == currentValue; ++j) {
                ++repeatCount;
            }
            if (repeatCount >= 3) {
                buf.method_10804(0);
                buf.method_10804(currentValue);
                buf.method_10804(repeatCount);
                i += repeatCount;
                previousValue = currentValue;
                continue;
            }
            buf.method_10804(1);
            int delta = currentValue - previousValue;
            buf.method_10804(delta);
            previousValue = currentValue;
            ++i;
        }
    }

    private static int[] decode(class_2540 buf) {
        int length = buf.method_10816();
        if (length == 0) {
            return new int[0];
        }
        int[] data = new int[length];
        int previousValue = 0;
        int i = 0;
        while (i < length) {
            int tag = buf.method_10816();
            if (tag == 0) {
                int value = buf.method_10816();
                int count = buf.method_10816();
                if (i + count > length) {
                    throw new DecoderException("RLE count exceeds array bounds");
                }
                for (int j = 0; j < count; ++j) {
                    data[i++] = value;
                }
                previousValue = value;
                continue;
            }
            if (tag == 1) {
                int delta = buf.method_10816();
                int currentValue = previousValue + delta;
                data[i++] = currentValue;
                previousValue = currentValue;
                continue;
            }
            throw new DecoderException("Unknown encoding tag: " + tag);
        }
        if (i != length) {
            throw new DecoderException("Decoded length mismatch");
        }
        return data;
    }

    @Override
    public class_5321<class_9139<class_2540, ? extends ModPacket>> type() {
        return TYPE;
    }

    @Override
    public void handle(Context context) {
        for (int i = 0; i < this.data.length; ++i) {
            CraftEngineBlockState craftEngineBlockState;
            class_2248 class_22482;
            int customId = i + BlockStateUtils.vanillaStateSize();
            int vanillaId = this.data[i];
            if (vanillaId == 0) continue;
            BlockManager.instance().remapState(customId, vanillaId);
            class_2680 customState = (class_2680)class_2248.field_10651.method_10200(customId);
            if (!(customState instanceof CraftEngineBlockState) || !((class_22482 = (craftEngineBlockState = (CraftEngineBlockState)customState).method_26204()) instanceof CraftEngineBlock)) continue;
            CraftEngineBlock craftEngineBlock = (CraftEngineBlock)class_22482;
            class_2680 vanillaState = (class_2680)class_2248.field_10651.method_10200(vanillaId);
            if (vanillaState == null) continue;
            craftEngineBlockState.setVisualBlockState(vanillaState);
            class_2248 vanillaBlock = vanillaState.method_26204();
            craftEngineBlock.setVisualBlock(vanillaBlock);
            BlockRenderUtils.registerRenderLayer(craftEngineBlock, vanillaState);
            BlockRenderUtils.registerColor(craftEngineBlock, vanillaBlock);
            BlockBehaviourAccessor customBlockAccessor = (BlockBehaviourAccessor)((Object)craftEngineBlock);
            BlockBehaviourAccessor vanillaBlockAccessor = (BlockBehaviourAccessor)vanillaBlock;
            customBlockAccessor.hasCollision(vanillaBlockAccessor.hasCollision());
            customBlockAccessor.explosionResistance(vanillaBlockAccessor.explosionResistance());
            customBlockAccessor.soundType(vanillaBlockAccessor.soundType());
            customBlockAccessor.friction(vanillaBlockAccessor.friction());
            customBlockAccessor.speedFactor(vanillaBlockAccessor.speedFactor());
            customBlockAccessor.jumpFactor(vanillaBlockAccessor.jumpFactor());
            customBlockAccessor.dynamicShape(vanillaBlockAccessor.dynamicShape());
            customBlockAccessor.requiredFeatures(vanillaBlockAccessor.requiredFeatures());
            customBlockAccessor.properties(vanillaBlockAccessor.properties());
            BlockStateBaseAccessor customStateAccessor = (BlockStateBaseAccessor)customState;
            BlockStateBaseAccessor vanillaStateAccessor = (BlockStateBaseAccessor)vanillaState;
            customStateAccessor.lightEmission(vanillaStateAccessor.lightEmission());
            customStateAccessor.useShapeForLightOcclusion(vanillaStateAccessor.useShapeForLightOcclusion());
            customStateAccessor.isAir(vanillaStateAccessor.isAir());
            customStateAccessor.ignitedByLava(vanillaStateAccessor.ignitedByLava());
            customStateAccessor.liquid(vanillaStateAccessor.liquid());
            customStateAccessor.pushReaction(vanillaStateAccessor.pushReaction());
            customStateAccessor.mapColor(vanillaStateAccessor.mapColor());
            customStateAccessor.destroySpeed(vanillaStateAccessor.destroySpeed());
            customStateAccessor.requiresCorrectToolForDrops(vanillaStateAccessor.requiresCorrectToolForDrops());
            customStateAccessor.canOcclude(vanillaStateAccessor.canOcclude());
            customStateAccessor.isRedstoneConductor(vanillaStateAccessor.isRedstoneConductor());
            customStateAccessor.isSuffocating(vanillaStateAccessor.isSuffocating());
            customStateAccessor.isViewBlocking(vanillaStateAccessor.isViewBlocking());
            customStateAccessor.hasPostProcess(vanillaStateAccessor.hasPostProcess());
            customStateAccessor.emissiveRendering(vanillaStateAccessor.emissiveRendering());
            customStateAccessor.spawnTerrainParticles(vanillaStateAccessor.spawnTerrainParticles());
            customStateAccessor.instrument(vanillaStateAccessor.instrument());
            customStateAccessor.replaceable(vanillaStateAccessor.replaceable());
            customStateAccessor.isRandomlyTicking(vanillaStateAccessor.isRandomlyTicking());
            customStateAccessor.offsetFunction(vanillaStateAccessor.offsetFunction());
            craftEngineBlockState.method_26200();
            customStateAccessor.fluidState(vanillaStateAccessor.fluidState());
            customBlockAccessor.isRandomlyTicking(vanillaBlockAccessor.isRandomlyTicking());
            customStateAccessor.legacySolid(vanillaStateAccessor.legacySolid());
            class_6880 vanillaBlockHolder = class_7923.field_41175.method_47983((Object)vanillaBlock);
            class_6880 customBlockHolder = class_7923.field_41175.method_47983((Object)craftEngineBlock);
            ((HolderReferenceInvoker)customBlockHolder).tags(((HolderReferenceInvoker)vanillaBlockHolder).tags());
        }
    }

    public static void handleTags() {
        if (previousPacket == null) {
            return;
        }
        for (int i = 0; i < VisualBlockStatePacket.previousPacket.data.length; ++i) {
            class_2248 class_22482;
            class_2680 vanillaState;
            int customId = i + BlockStateUtils.vanillaStateSize();
            int vanillaId = VisualBlockStatePacket.previousPacket.data[i];
            if (vanillaId == 0 || (vanillaState = (class_2680)class_2248.field_10651.method_10200(vanillaId)) == null) continue;
            class_2248 vanillaBlock = vanillaState.method_26204();
            class_2680 customState = (class_2680)class_2248.field_10651.method_10200(customId);
            if (customState == null || !((class_22482 = customState.method_26204()) instanceof CraftEngineBlock)) continue;
            CraftEngineBlock craftEngineBlock = (CraftEngineBlock)class_22482;
            class_6880 vanillaBlockHolder = class_7923.field_41175.method_47983((Object)vanillaBlock);
            class_6880 customBlockHolder = class_7923.field_41175.method_47983((Object)craftEngineBlock);
            ((HolderReferenceInvoker)customBlockHolder).tags(((HolderReferenceInvoker)vanillaBlockHolder).tags());
        }
    }
}

