/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import com.mojang.authlib.GameProfile;
import java.util.concurrent.atomic.AtomicReference;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends class_1657 {
    @Shadow
    private boolean field_23193;

    @Shadow
    public abstract boolean method_5873(class_1297 var1, boolean var2);

    @Shadow
    public abstract void method_5848();

    public ServerPlayerMixin(class_1937 p_250508_, class_2338 p_250289_, float p_251702_, GameProfile p_252153_) {
        super(p_250508_, p_250289_, p_251702_, p_252153_);
    }

    @ModifyVariable(method={"setRespawnPosition(Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/core/BlockPos;FZZ)V"}, at=@At(value="HEAD"))
    private class_2338 modifyBlockPos(class_2338 originalPos) {
        AtomicReference<class_2338> newPos = new AtomicReference<class_2338>(originalPos);
        InPlayerBlockPos.check(originalPos, (pl, realPos) -> newPos.set(class_2338.method_49638((class_2374)MorphUtils.getRealBlockPos(pl, realPos))), () -> newPos.set(null), (class_4538)this.method_37908());
        return newPos.get();
    }

    @Inject(method={"setRespawnPosition"}, at={@At(value="TAIL")})
    public void force(class_5321<class_1937> p_9159_, class_2338 pos, float p_9161_, boolean p_9162_, boolean p_9163_, CallbackInfo ci) {
        if (pos != null && InPlayerBlockPos.isMorphedPlayerX(pos.method_10263())) {
            this.field_23193 = true;
        }
    }

    @Inject(method={"startSleeping"}, at={@At(value="TAIL")})
    public void bound(class_2338 pos, CallbackInfo ci) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> this.method_5873((class_1297)pl.player(), true), null, (class_4538)this.method_37908());
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="HEAD")})
    public void unbound(boolean p_9165_, boolean p_9166_, CallbackInfo ci) {
        this.method_18398().ifPresent(blockpos -> {
            if (InPlayerBlockPos.isMorphedPlayerX(blockpos.method_10263())) {
                this.method_5848();
            }
        });
    }

    @Inject(method={"isReachableBedBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void realInRange(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.method_10263())) {
            class_243 real = InPlayerBlockPos.checkOnReal(class_243.method_24955((class_2382)pos));
            cir.setReturnValue((Object)(Math.abs(this.method_23317() - real.method_10216()) <= 3.0 && Math.abs(this.method_23318() - real.method_10214()) <= 2.0 && Math.abs(this.method_23321() - real.method_10215()) <= 3.0 ? 1 : 0));
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    public void dead(class_1282 damageSource, CallbackInfo ci) {
        if (PlayerAccessor.of(this).isFullActive() && !damageSource.method_49708(MorphUtils.PLAYER_DESTROYED) && !damageSource.method_49708(MorphUtils.PLAYER_DESTROYED_NULL)) {
            PlayerAccessor.of(this).getBlocksData2().values().forEach(block -> this.method_37908().method_20290(2001, block.getPos(), class_2248.method_9507((class_2680)block.getBlockState())));
        }
    }

    @Inject(method={"restoreFrom"}, at={@At(value="TAIL")})
    public void restoreBlockMorphData(class_3222 old, boolean fromEnd, CallbackInfo ci) {
        PlayerAccessor pl = PlayerAccessor.of(this);
        PlayerAccessor oldPl = PlayerAccessor.of((class_1657)old);
        if (!fromEnd && Config.getInstance().getValue("playerDieAfterDestroy", Boolean.class).booleanValue()) {
            pl.applyBlockMorph(class_2246.field_10124.method_9564(), null, BannedBlock.Source.SYSTEM);
            for (InPlayerBlockPos pos : oldPl.getUpdates()) {
                pl.prepareSync(pos);
            }
        } else {
            pl.loadBlockData(oldPl.saveBlockData(false), null, true);
        }
    }

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(class_3218 lv, class_1282 damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        if (MorphUtils.onPlayerAttacked((class_1309)this, damageSource, f)) {
            cir.setReturnValue((Object)false);
        }
    }
}

