/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.CollectionTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.CompoundTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive.NumericTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive.StringTagRenderer;
import net.blockomorph.utils.MorphUtils;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_4614;
import org.jetbrains.annotations.Nullable;

public class TagTypes {
    private static final HashMap<class_4614<?>, TagRendererFactory<?>> RENDERERS = new HashMap();
    private static final HashMap<class_4614<?>, Supplier<?>> TAGS = new HashMap();

    public static <T extends class_2520> void registerRenderer(class_4614<T> type, TagRendererFactory<T> factory) {
        if (RENDERERS.containsKey(type)) {
            throw new IllegalArgumentException("Type " + type.method_23259() + " already registered!");
        }
        RENDERERS.put(type, factory);
    }

    public static <T extends class_2520> void registerTagCreator(class_4614<T> type, Supplier<T> creator) {
        if (TAGS.containsKey(type)) {
            throw new IllegalArgumentException("Type " + type.method_23259() + " already registered!");
        }
        TAGS.put(type, creator);
    }

    public static class_4614<?>[] getRegisteredTags() {
        class_4614[] array = new class_4614[TAGS.size()];
        int i = 0;
        Iterator<class_4614<?>> iterator = TAGS.keySet().iterator();
        while (iterator.hasNext()) {
            class_4614<?> tagType;
            array[i] = tagType = iterator.next();
            ++i;
        }
        return array;
    }

    @Nullable
    public static <T extends class_2520> TagRenderer<T> getRendererForTag(String name, T tag, TagRendererContext<T> ctx) {
        try {
            TagRendererFactory<?> renderSource = RENDERERS.get(tag.method_23258());
            if (renderSource != null) {
                return renderSource.create(name, tag, ctx);
            }
        }
        catch (ClassCastException e) {
            MorphUtils.LOGGER.error("Invalid tag registration for NBT Editor: ", (Throwable)e);
            return null;
        }
        return null;
    }

    public static <T extends class_2520> Supplier<T> createDefaultTag(class_4614<T> type) {
        try {
            return TAGS.get(type);
        }
        catch (Exception e) {
            MorphUtils.LOGGER.error("Invalid tag registration for NBT Editor: ", (Throwable)e);
            return null;
        }
    }

    static {
        TagTypes.registerRenderer(class_2487.field_21029, CompoundTagRenderer::new);
        TagTypes.registerRenderer(class_2519.field_21045, StringTagRenderer::new);
        TagTypes.registerRenderer(class_2497.field_21037, NumericTagRenderer.IntTagRenderer::new);
        TagTypes.registerRenderer(class_2503.field_21041, NumericTagRenderer.LongTagRenderer::new);
        TagTypes.registerRenderer(class_2489.field_21031, NumericTagRenderer.DoubleTagRenderer::new);
        TagTypes.registerRenderer(class_2494.field_21035, NumericTagRenderer.FloatTagRenderer::new);
        TagTypes.registerRenderer(class_2516.field_21043, NumericTagRenderer.ShortTagRenderer::new);
        TagTypes.registerRenderer(class_2481.field_21025, NumericTagRenderer.ByteTagRenderer::new);
        TagTypes.registerRenderer(class_2499.field_21039, CollectionTagRenderer.ListTagRenderer::new);
        TagTypes.registerRenderer(class_2495.field_21036, CollectionTagRenderer.IntArrayTagRenderer::new);
        TagTypes.registerRenderer(class_2501.field_21040, CollectionTagRenderer.LongArrayTagRenderer::new);
        TagTypes.registerRenderer(class_2479.field_21024, CollectionTagRenderer.ByteArrayTagRenderer::new);
        TagTypes.registerTagCreator(class_2519.field_21045, () -> class_2519.method_23256((String)""));
        TagTypes.registerTagCreator(class_2487.field_21029, class_2487::new);
        TagTypes.registerTagCreator(class_2499.field_21039, class_2499::new);
        TagTypes.registerTagCreator(class_2495.field_21036, () -> new class_2495(new int[0]));
        TagTypes.registerTagCreator(class_2501.field_21040, () -> new class_2501(new long[0]));
        TagTypes.registerTagCreator(class_2479.field_21024, () -> new class_2479(new byte[0]));
        TagTypes.registerTagCreator(class_2497.field_21037, () -> class_2497.method_23247((int)0));
        TagTypes.registerTagCreator(class_2503.field_21041, () -> class_2503.method_23251((long)0L));
        TagTypes.registerTagCreator(class_2489.field_21031, () -> class_2489.method_23241((double)0.0));
        TagTypes.registerTagCreator(class_2494.field_21035, () -> class_2494.method_23244((float)0.0f));
        TagTypes.registerTagCreator(class_2516.field_21043, () -> class_2516.method_23254((short)0));
        TagTypes.registerTagCreator(class_2481.field_21025, () -> class_2481.method_23233((byte)0));
    }

    @FunctionalInterface
    public static interface TagRendererFactory<T extends class_2520> {
        public TagRenderer<T> create(String var1, T var2, TagRendererContext<T> var3);
    }
}

