/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers;

import com.mojang.brigadier.Message;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.blockomorph.screens.morphConfig.nbtEditor.TagTypes;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagAddingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.primitive.NumericTagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_4614;
import net.minecraft.class_9848;

public class CollectionTagRenderer<LIST extends class_2483<? extends class_2520>>
extends TagRenderer<LIST> {
    private static final int BUTTON_SIZE = 16;
    private final class_4614<?>[] allowedTypes;
    private static final List<class_2561> HINT = Stream.of(class_2561.method_43471((String)"blockomorph.gui.nbtEditor.addOverlay.hint.collectionTag").getString().split("\n")).map(word -> class_2561.method_54155((Message)class_2561.method_43470((String)word))).toList();
    private boolean hovered;
    private final int color;

    protected CollectionTagRenderer(String tagName, LIST tag, TagRendererContext<LIST> ctx, int color, class_4614<?> ... allowedTypes) {
        super(tagName, tag, ctx);
        this.color = color;
        this.allowedTypes = allowedTypes;
    }

    @Override
    public void renderPlate(GuiUtils gui, int number) {
        gui.fill(this.box.method_3321(), this.box.method_3322(), this.box.method_3321() + this.box.method_3319(), this.box.method_3322() + this.box.method_3320(), this.color);
        super.renderPlate(gui, number);
    }

    @Override
    public void render(GuiUtils gui) {
        int x = this.box.method_3321() + (this.hasName() ? 61 : this.box.method_3319() - 3 - 16);
        int y = this.box.method_3322() + 2;
        this.hovered = GuiUtils.isMouseOver(x, y, x + 16, y + 16, gui.getMouseX(), gui.getMouseY());
        gui.blit(TAGS_SPRITE, x, y, 160.0f, this.hovered ? 16.0f : 0.0f, 16, 16, 194, 200);
    }

    @Override
    protected void renderLine(GuiUtils gui, int number) {
        this.renderDynamicColorLine(gui);
    }

    @Override
    public boolean canEnterInTag() {
        return true;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY) {
        if (this.hovered) {
            this.enterInTag();
            GuiUtils.playClickSound();
            return true;
        }
        return false;
    }

    @Override
    protected Integer getPlateNumber() {
        return 3;
    }

    @Override
    public int getFrameColor() {
        return this.color;
    }

    @Override
    public List<TagRenderer<?>> getEnteringTags() {
        ArrayList renderers = new ArrayList();
        int i = 1;
        for (class_2520 tag : (class_2483)this.getTag()) {
            if (tag == null) continue;
            int index = i++;
            TagRenderer<class_2520> renderer = TagTypes.getRendererForTag("" + index, tag, this.tagRendererContext.withTagUpdateListener(newTag -> ((class_2483)this.getTag()).method_10535(index - 1, newTag)));
            renderers.add(renderer);
        }
        return renderers;
    }

    @Override
    public class_2520 tryWalk(String nameElementInThisTag) {
        try {
            int index = Integer.parseInt(nameElementInThisTag) - 1;
            return (class_2520)((class_2483)this.getTag()).get(index);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public TagEditingOverlay getTagAddOverlay() {
        return new TagAddingOverlay<class_2520>(name -> {
            if (name.isEmpty()) {
                return true;
            }
            try {
                int index = Integer.parseInt(name) - 1;
                if (index >= 0 && index < ((class_2483)this.getTag()).size()) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return false;
        }, (name, tag) -> {
            int index = name.isEmpty() ? ((class_2483)this.getTag()).size() : Integer.parseInt(name) - 1;
            this.signalChange(() -> ((class_2483)this.getTag()).method_10533(index, tag), false, index + 1);
        }, this::getAddOverlayHint, HINT, true, this.allowedTypes);
    }

    private String getAddOverlayHint() {
        if (((class_2483)this.getTag()).isEmpty()) {
            return "*Adding to end*";
        }
        if (((class_2483)this.getTag()).size() == 1) {
            return "1";
        }
        return "1-" + ((class_2483)this.getTag()).size();
    }

    @Override
    public void deleteTag(String name) {
        try {
            int index = Integer.parseInt(name);
            if (index - 1 < ((class_2483)this.getTag()).size() && index - 1 >= 0) {
                this.signalChange(() -> ((class_2483)this.getTag()).method_10536(index - 1), true, index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void signalChange(Runnable action, boolean delete, int userFormatIndex) {
        List<Integer> numbersOld = this.getNumberList();
        action.run();
        HashMap<CallSite, CallSite> map = new HashMap<CallSite, CallSite>();
        for (int number : numbersOld) {
            if (number == userFormatIndex) continue;
            map.put((CallSite)((Object)("" + number)), (CallSite)((Object)("" + (number > userFormatIndex ? number + (delete ? -1 : 1) : number))));
        }
        this.tagRendererContext.onSoftRebuildRequested().accept(map);
        this.tagRendererContext.onMainTagEdited().run();
    }

    private List<Integer> getNumberList() {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        for (int i = 0; i < ((class_2483)this.getTag()).size(); ++i) {
            numbers.add(i + 1);
        }
        return numbers;
    }

    public static final class ByteArrayTagRenderer
    extends CollectionTagRenderer<class_2479> {
        public ByteArrayTagRenderer(String tagName, class_2479 tag, TagRendererContext<class_2479> ctx) {
            super(tagName, tag, ctx, NumericTagRenderer.BYTE_COLOR, class_2481.field_21025);
        }
    }

    public static final class LongArrayTagRenderer
    extends CollectionTagRenderer<class_2501> {
        public LongArrayTagRenderer(String tagName, class_2501 tag, TagRendererContext<class_2501> ctx) {
            super(tagName, tag, ctx, NumericTagRenderer.LONG_COLOR, class_2503.field_21041);
        }
    }

    public static final class IntArrayTagRenderer
    extends CollectionTagRenderer<class_2495> {
        public IntArrayTagRenderer(String tagName, class_2495 tag, TagRendererContext<class_2495> ctx) {
            super(tagName, tag, ctx, NumericTagRenderer.INT_COLOR, class_2497.field_21037);
        }
    }

    public static final class ListTagRenderer
    extends CollectionTagRenderer<class_2499> {
        public ListTagRenderer(String tagName, class_2499 tag, TagRendererContext<class_2499> ctx) {
            super(tagName, tag, ctx, class_9848.method_61324((int)255, (int)245, (int)172, (int)47), TagTypes.getRegisteredTags());
        }
    }
}

