/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.DimAccessor;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4048;

public class HitBoxCalculator {
    private InPlayerBlockPos minPos = InPlayerBlockPos.get(0, 0, 0);
    private InPlayerBlockPos maxPos = InPlayerBlockPos.get(0, 0, 0);
    private final PlayerAccessor pl;

    public HitBoxCalculator(PlayerAccessor owner) {
        this.pl = owner;
    }

    public InPlayerBlockPos getMinPos() {
        return this.minPos;
    }

    public InPlayerBlockPos getMaxPos() {
        return this.maxPos;
    }

    public void recalculatePositions() {
        this.minPos = this.findMinPos();
        this.maxPos = this.findMaxPos();
    }

    private class_238 centerAABB(class_238 original, class_243 center) {
        double width = original.field_1320 - original.field_1323;
        double height = original.field_1325 - original.field_1322;
        double depth = original.field_1324 - original.field_1321;
        return new class_238(center.field_1352 - width / 2.0, center.field_1351, center.field_1350 - depth / 2.0, center.field_1352 + width / 2.0, center.field_1351 + height, center.field_1350 + depth / 2.0);
    }

    private InPlayerBlockPos findMinPos() {
        if (this.pl.getBlocksData2().isEmpty()) {
            return InPlayerBlockPos.ZERO;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (InPlayerBlockPos pos : this.pl.getBlocksData2().keySet()) {
            if (pos.getX() < minX) {
                minX = pos.getX();
            }
            if (pos.getY() < minY) {
                minY = pos.getY();
            }
            if (pos.getZ() >= minZ) continue;
            minZ = pos.getZ();
        }
        return InPlayerBlockPos.get(minX, minY, minZ);
    }

    private InPlayerBlockPos findMaxPos() {
        if (this.pl.getBlocksData2().isEmpty()) {
            return InPlayerBlockPos.get(1, 1, 1);
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (InPlayerBlockPos pos : this.pl.getBlocksData2().keySet()) {
            if (pos.getX() > maxX) {
                maxX = pos.getX();
            }
            if (pos.getY() > maxY) {
                maxY = pos.getY();
            }
            if (pos.getZ() <= maxZ) continue;
            maxZ = pos.getZ();
        }
        return InPlayerBlockPos.get(maxX, maxY, maxZ).offset(1, 1, 1);
    }

    public class_4048 calculateDimensions() {
        return DimAccessor.dynamic(vec3 -> {
            class_238 ab = new class_238(vec3.field_1352 + (double)this.minPos.getX(), vec3.field_1351 + (double)this.minPos.getY(), vec3.field_1350 + (double)this.minPos.getZ(), vec3.field_1352 + (double)this.maxPos.getX(), vec3.field_1351 + (double)this.maxPos.getY(), vec3.field_1350 + (double)this.maxPos.getZ());
            return this.centerAABB(ab, (class_243)vec3);
        }, this.getEyeHeight());
    }

    public float getEyeHeight() {
        return (float)(this.maxPos.getY() - 1) + 0.83300006f + (this.pl.player().method_18276() ? -0.125f : 0.0f);
    }
}

