/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.SavedBlock;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;

public class SavedBlockManager {
    private final Path gameDir;
    private boolean init;
    private final HashMap<String, SavedBlock> blocks = new HashMap();

    public SavedBlockManager(Path gameDir) {
        this.gameDir = gameDir.resolve("saved_blocks.bmdat");
    }

    public void load() {
        if (!this.init) {
            try {
                class_2487 tag = class_2507.method_10633((Path)this.gameDir);
                if (tag != null) {
                    for (String key : tag.method_10541()) {
                        this.blocks.put(key, SavedBlock.fromTag(tag.method_10562(key), key));
                    }
                }
                this.init = true;
            }
            catch (Exception e) {
                MorphUtils.LOGGER.error("An error occurred while loading saved blocks", (Throwable)e);
            }
        }
    }

    public HashMap<String, SavedBlock> get() {
        return this.blocks;
    }

    public void delete(String s) {
        if (this.blocks.containsKey(s)) {
            this.blocks.remove(s);
            this.write();
        }
    }

    public void add(SavedBlock b) {
        String s = b.getName();
        if (!this.blocks.containsKey(s)) {
            this.blocks.put(s, b);
            this.write();
        }
    }

    public void clear() {
        this.blocks.clear();
        this.write();
    }

    public void write() {
        try {
            class_2487 tag = new class_2487();
            for (Map.Entry<String, SavedBlock> entry : this.blocks.entrySet()) {
                tag.method_10566(entry.getKey(), (class_2520)entry.getValue().toNbt());
            }
            class_2507.method_10630((class_2487)tag, (Path)this.gameDir);
        }
        catch (Exception e) {
            MorphUtils.LOGGER.error("An error occurred while saving favourite blocks", (Throwable)e);
        }
    }
}

