/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.blockomorph.screens.config.renderers.BooleanConfigRenderer;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public class BooleanConfig
extends ConfigInstance<Boolean> {
    private static BooleanConfigRenderer RENDERER;

    public BooleanConfig(String name, Boolean initialValue, boolean canOperatorModify, @Nullable class_2561 tip) {
        super(name, initialValue, canOperatorModify, tip);
    }

    @Override
    public void readFromStorage(JsonElement option) {
        this.value = option.getAsBoolean();
    }

    @Override
    public JsonElement getDataForStorage() {
        return new JsonPrimitive((Boolean)this.value);
    }

    @Override
    public void parseFromUser(String value) {
        this.value = Boolean.parseBoolean(value);
    }

    @Override
    public void readFromNetwork(class_2540 buf) {
        this.value = buf.readBoolean();
    }

    @Override
    public void writeToNetwork(class_2540 buf) {
        buf.method_52964(((Boolean)this.value).booleanValue());
    }

    @Override
    public LiteralArgumentBuilder<class_2168> buildArgument(LiteralArgumentBuilder<class_2168> optionNameArgument, class_7157 context, class_2170.class_5364 environment) {
        return (LiteralArgumentBuilder)optionNameArgument.then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(args -> {
            this.value = BoolArgumentType.getBool((CommandContext)args, (String)"value");
            Config.getInstance().writeAndSend();
            ((class_2168)args.getSource()).method_9226(() -> class_2561.method_43469((String)"blockomorph.commands.option_change.default", (Object[])new Object[]{this.name, ((Boolean)this.value).toString()}), true);
            return 1;
        }));
    }

    public BooleanConfigRenderer getRenderer() {
        if (RENDERER == null) {
            RENDERER = new BooleanConfigRenderer();
        }
        return RENDERER;
    }
}

