/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.blockomorph.command.EnumArgument;
import net.blockomorph.screens.config.ConfigRenderer;
import net.blockomorph.screens.config.renderers.EnumConfigRenderer;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public class EnumConfig<T extends Enum<T>>
extends ConfigInstance<T> {
    private static EnumConfigRenderer RENDERER;
    private final Class<T> classType;

    public EnumConfig(String name, T initialValue, boolean canOperatorModify, @Nullable class_2561 tip) {
        super(name, initialValue, canOperatorModify, tip);
        this.classType = ((Enum)this.value).getDeclaringClass();
    }

    public Class<T> getEnumClass() {
        return this.classType;
    }

    @Override
    public void readFromStorage(JsonElement option) {
        this.parseFromUser(option.getAsString());
    }

    @Override
    public JsonElement getDataForStorage() {
        return new JsonPrimitive(((Enum)this.value).name());
    }

    @Override
    public void parseFromUser(String input) {
        try {
            this.value = Enum.valueOf(this.classType, input);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid option value for option: " + this.getName() + ", value: " + input);
        }
    }

    @Override
    public void readFromNetwork(class_2540 buf) {
        this.value = buf.method_10818(this.classType);
    }

    @Override
    public void writeToNetwork(class_2540 buf) {
        buf.method_10817((Enum)this.value);
    }

    @Override
    public LiteralArgumentBuilder<class_2168> buildArgument(LiteralArgumentBuilder<class_2168> optionNameArgument, class_7157 context, class_2170.class_5364 environment) {
        return (LiteralArgumentBuilder)optionNameArgument.then(class_2170.method_9244((String)"value", EnumArgument.enumArg(this.classType)).executes(args -> {
            this.value = EnumArgument.getEnum((CommandContext<class_2168>)args, "value", this.classType);
            Config.getInstance().writeAndSend();
            ((class_2168)args.getSource()).method_9226(() -> class_2561.method_43469((String)"blockomorph.commands.option_change.default", (Object[])new Object[]{this.name, ((Enum)this.value).toString()}), true);
            return 1;
        }));
    }

    @Override
    public ConfigRenderer<?> getRenderer() {
        if (RENDERER == null) {
            RENDERER = new EnumConfigRenderer();
        }
        return RENDERER;
    }
}

