/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils.dataSyncher;

import java.util.Objects;
import net.blockomorph.utils.dataSyncher.SyncedEntity;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public abstract class AutoSyncedEntityData<DATA> {
    protected DATA data;
    protected final class_2960 id;
    protected boolean isDirty;
    private final SyncedEntity entity;
    private final Runnable onSynced;

    protected AutoSyncedEntityData(class_1297 entity, class_2960 id, DATA defaultValue, Runnable onSynced) {
        if (!(entity instanceof SyncedEntity)) {
            throw new IllegalStateException("Cannot register entity syncer from blockomorph! Most likely mixin not applied or missing! Class: " + String.valueOf(entity.getClass()) + " Id: " + String.valueOf(id));
        }
        SyncedEntity syncedEntity = (SyncedEntity)entity;
        syncedEntity.registerDataSyncer(this);
        this.id = id;
        this.entity = syncedEntity;
        this.data = Objects.requireNonNull(defaultValue);
        this.onSynced = onSynced;
    }

    public class_2960 getId() {
        return this.id;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public final void writeInNetwork(class_2540 buffer) {
        this.writeInBuffer(buffer);
        this.isDirty = false;
    }

    public final void readFromNetwork(class_2540 buffer) {
        this.readFromBuffer(buffer);
    }

    protected abstract void readFromBuffer(class_2540 var1);

    protected abstract void writeInBuffer(class_2540 var1);

    public final void onReceived() {
        if (this.onSynced != null) {
            this.onSynced.run();
        }
    }

    public void set(DATA data) {
        if (!this.data.equals(data)) {
            this.data = data;
            this.isDirty = true;
            this.entity.setDirty();
            this.onReceived();
        }
    }

    public DATA get() {
        return this.data;
    }
}

