/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public class EnumArgument<ENUM extends Enum<ENUM>>
implements ArgumentType<ENUM> {
    private static final Dynamic2CommandExceptionType INVALID_VALUE = new Dynamic2CommandExceptionType((found, constants) -> class_2561.method_43469((String)"blockomorph.commands.enum_argument.wrong", (Object[])new Object[]{found, constants}));
    private final Class<ENUM> type;

    private EnumArgument(Class<ENUM> type) {
        this.type = type;
    }

    public ENUM parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Enum.valueOf(this.type, name);
        }
        catch (IllegalArgumentException e) {
            throw INVALID_VALUE.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)this.getEnumList().toString());
        }
    }

    public static <ENUM_CLASS extends Enum<ENUM_CLASS>> EnumArgument<ENUM_CLASS> enumArg(Class<ENUM_CLASS> type) {
        return new EnumArgument<ENUM_CLASS>(type);
    }

    public static <ENUM_CLASS extends Enum<ENUM_CLASS>> ENUM_CLASS getEnum(CommandContext<class_2168> commandContext, String name, Class<ENUM_CLASS> data) {
        return (ENUM_CLASS)((Enum)commandContext.getArgument(name, data));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(this.getEnumList(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return this.getEnumList();
    }

    private List<String> getEnumList() {
        return Stream.of((Enum[])this.type.getEnumConstants()).map(Enum::name).toList();
    }

    public static class ContextInfo<ENUM extends Enum<ENUM>>
    implements class_2314<EnumArgument<ENUM>, Template> {
        public void serializeToNetwork(Template template, class_2540 buffer) {
            buffer.method_10814(template.enumType.getName());
        }

        @Nullable
        public Template deserializeFromNetwork(class_2540 buffer) {
            try {
                return new Template(Class.forName(buffer.method_19772()));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("enum", template.enumType.getName());
        }

        public Template unpack(EnumArgument<ENUM> argument) {
            return new Template(argument.type);
        }

        public class Template
        implements class_2314.class_7217<EnumArgument<ENUM>> {
            final Class<ENUM> enumType;

            private Template(Class<ENUM> enumType) {
                this.enumType = enumType;
            }

            public EnumArgument<ENUM> instantiate(class_7157 c) {
                return new EnumArgument(this.enumType);
            }

            public class_2314<EnumArgument<ENUM>, ?> method_41728() {
                return ContextInfo.this;
            }
        }
    }
}

