/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main;

import java.util.Optional;
import net.blockomorph.utils.ChairController;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.accessors.EntityAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class}, priority=1020)
public abstract class EntityMixin
implements EntityAccessor {
    @Shadow
    private class_1937 field_6002;
    @Unique
    private class_243 fromMorphedPos;
    private final ChairController CHAIR_CONTROLLER = new ChairController((class_1297)this);
    @Unique
    private class_243 tempPos;
    @Unique
    private class_243 tpPos;

    @Shadow
    public abstract boolean method_5626(class_1297 var1);

    @Shadow
    public abstract class_1937 method_37908();

    @Shadow
    public abstract boolean method_5873(class_1297 var1, boolean var2);

    @Shadow
    public abstract class_4048 method_18377(class_4050 var1);

    @Shadow
    public abstract class_243 method_19538();

    @Override
    public class_243 getMorphedPos() {
        return this.fromMorphedPos;
    }

    @Override
    @Nullable
    public class_243 getSyncedPos() {
        class_2487 tg = this.CHAIR_CONTROLLER.getTagData();
        if (!tg.method_33133()) {
            class_243 vec = new class_243(tg.method_10574("x"), tg.method_10574("y"), tg.method_10574("z"));
            return InPlayerBlockPos.checkOnReal(vec);
        }
        return null;
    }

    @Inject(method={"distanceToSqr(DDD)D"}, at={@At(value="RETURN")}, cancellable=true)
    public void getRealCoordsSqr(double x, double y, double z, CallbackInfoReturnable<Double> cir) {
        MorphUtils.distanceTo(new class_243(x, y, z), ((class_1297)this).method_19538(), true, 0.0, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"distanceToSqr(Lnet/minecraft/world/phys/Vec3;)D"}, at={@At(value="RETURN")}, cancellable=true)
    public void getRealCoordsVec3(class_243 pos, CallbackInfoReturnable<Double> cir) {
        MorphUtils.distanceTo(pos, ((class_1297)this).method_19538(), true, 0.0, arg_0 -> cir.setReturnValue(arg_0));
    }

    @Inject(method={"getBoundingBoxForPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void getRealPos(class_4050 pose, CallbackInfoReturnable<class_238> cir) {
        PlayerAccessor pl;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof PlayerAccessor && (pl = (PlayerAccessor)((Object)entityMixin)).isFullActive()) {
            cir.setReturnValue((Object)this.method_18377(pose).method_30757(this.method_19538()));
        }
    }

    @Inject(method={"isAttackable"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkAccess(CallbackInfoReturnable<Boolean> cir) {
        PlayerAccessor pl;
        if (Config.getInstance().getValue((String)"hitReaction", Config.HitReaction.class).hand) {
            return;
        }
        EntityMixin entityMixin = this;
        if (entityMixin instanceof PlayerAccessor && (pl = (PlayerAccessor)((Object)entityMixin)).isActive()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"setPosRaw"}, at={@At(value="HEAD")})
    public void redirect(double x, double y, double z, CallbackInfo ci) {
        class_243 vec = new class_243(x, y, z);
        this.tempPos = InPlayerBlockPos.checkOnReal(vec);
        if (!this.tempPos.equals((Object)vec)) {
            this.fromMorphedPos = vec;
        }
    }

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void correctPos(class_1297 passanger, class_1297.class_4738 setPosition, CallbackInfo ci) {
        if (this.method_5626(passanger)) {
            EntityAccessor acc;
            class_243 vec3;
            if (passanger instanceof EntityAccessor && (vec3 = (acc = (EntityAccessor)passanger).getSyncedPos()) != null) {
                setPosition.accept(passanger, vec3.field_1352, vec3.field_1351, vec3.field_1350);
                ci.cancel();
            } else if (passanger instanceof class_1309) {
                class_1309 livingEntity = (class_1309)passanger;
                Optional pos = livingEntity.method_18398();
                pos.ifPresent(blockpos -> {
                    if (InPlayerBlockPos.isMorphedPlayerX(blockpos.method_10263())) {
                        class_243 bedPos = InPlayerBlockPos.checkOnReal(class_243.method_24953((class_2382)blockpos));
                        setPosition.accept(passanger, bedPos.field_1352, bedPos.field_1351 + 0.0625, bedPos.field_1350);
                        ci.cancel();
                    }
                });
            }
        }
    }

    @Inject(method={"setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void rejectInvalidMovement(class_243 vec3, CallbackInfo ci) {
        if (this instanceof class_1676 && (vec3.field_1352 > 2.9999995E7 || vec3.field_1350 > 2.9999995E7 || vec3.field_1350 < -2.9999995E7)) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        this.CHAIR_CONTROLLER.tick();
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")})
    public void stopRiding(CallbackInfo ci) {
        this.CHAIR_CONTROLLER.onStopRiding();
    }

    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPose(Lnet/minecraft/world/entity/Pose;)V")}, cancellable=true)
    public void startRidingCheck(class_1297 entity, boolean p_19967_, CallbackInfoReturnable<Boolean> cir) {
        class_1297 ent = this.CHAIR_CONTROLLER.replaceEntityOnMorphedPlayer(entity);
        if (ent != entity) {
            cir.setReturnValue((Object)true);
            this.method_5873(ent, true);
        }
    }

    @ModifyVariable(method={"setPosRaw"}, at=@At(value="HEAD"), ordinal=0)
    public double getX(double value) {
        return this.tempPos.field_1352;
    }

    @ModifyVariable(method={"setPosRaw"}, at=@At(value="HEAD"), ordinal=1)
    public double getY(double value) {
        return this.tempPos.field_1351;
    }

    @ModifyVariable(method={"setPosRaw"}, at=@At(value="HEAD"), ordinal=2)
    public double getZ(double value) {
        return this.tempPos.field_1350;
    }

    @Inject(method={"absMoveTo(DDD)V"}, at={@At(value="HEAD")})
    public void redirectTp(double x, double y, double z, CallbackInfo ci) {
        this.tpPos = InPlayerBlockPos.checkOnReal(new class_243(x, y, z));
    }

    @ModifyVariable(method={"absMoveTo(DDD)V"}, at=@At(value="HEAD"), ordinal=0)
    public double getXtp(double value) {
        return this.tpPos.field_1352;
    }

    @ModifyVariable(method={"absMoveTo(DDD)V"}, at=@At(value="HEAD"), ordinal=1)
    public double getYtp(double value) {
        return this.tpPos.field_1351;
    }

    @ModifyVariable(method={"absMoveTo(DDD)V"}, at=@At(value="HEAD"), ordinal=2)
    public double getZtp(double value) {
        return this.tpPos.field_1350;
    }

    @Override
    public void forceLevelChange(class_1937 lv) {
        this.field_6002 = lv;
    }
}

