/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.config;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.blockomorph.screens.config.ConfigRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ScrollerManager;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_6382;
import net.minecraft.class_768;

public class ConfigRenderableList
extends class_339 {
    private final GuiUtils gui = new GuiUtils();
    private final List<RenderableConfigInstance<?>> renderables = new ArrayList(7);
    private final List<ConfigRenderer<?>> types = new ArrayList();
    protected final ScrollerManager<RenderableConfigInstance<?>> scrollerManager;
    private final int plateHeight;
    private final int plateLength;

    public ConfigRenderableList(List<ConfigInstance<?>> options, ConfigRenderer.ConfigRenderingContext ctx, int x, int y, int length, int height, int barX, int barY, int barHeight, int plateHeight, int plateLength) {
        super(x, y, length, height, class_5244.field_39003);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (ConfigInstance<?> option : options) {
            if (!option.canEditedByOperators()) continue;
            builder.add(new RenderableConfigInstance(option, ctx));
            if (this.types.contains(option.getRenderer())) continue;
            this.types.add(option.getRenderer());
        }
        this.types.forEach(ConfigRenderer::init);
        this.scrollerManager = new ScrollerManager(() -> barX, () -> barY, barHeight, 1, 7, this.renderables, null);
        this.scrollerManager.setMainList((List<RenderableConfigInstance<?>>)builder.build());
        this.plateHeight = plateHeight;
        this.plateLength = plateLength;
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.gui.setGuiGraphics(guiGraphics, class_310.method_1551().field_1772, mouseX, mouseY, delta);
        this.scrollerManager.renderScroller(this.gui);
        this.renderPlates(false);
        this.renderPlates(true);
        this.renderables.forEach(renderer -> renderer.renderTooltip(this.gui));
    }

    private void renderPlates(boolean mainPhase) {
        for (int i = 0; i < this.renderables.size(); ++i) {
            int yStart = this.method_46427() + i * this.plateHeight;
            this.renderables.get(i).render(this.gui, this.method_46426(), yStart, this.plateLength, this.plateHeight, mainPhase);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int type) {
        if (type == 0) {
            this.types.forEach(ConfigRenderer::startClick);
            for (RenderableConfigInstance<?> instance : this.renderables) {
                if (!instance.mouseClicked(mouseX, mouseY)) continue;
                this.types.forEach(ConfigRenderer::endClick);
                return true;
            }
            this.types.forEach(ConfigRenderer::endClick);
        }
        return this.scrollerManager.mouseClicked(mouseX, mouseY);
    }

    public boolean method_25401(double x, double y, double yScrolled) {
        for (RenderableConfigInstance<?> instance : this.renderables) {
            if (!instance.mouseScrolled(x, y, yScrolled)) continue;
            return true;
        }
        return this.scrollerManager.mouseScrolled(yScrolled);
    }

    public boolean method_25403(double mouseX, double mouseY, int type, double mouseXOffset, double mouseYOffset) {
        return this.scrollerManager.mouseDragged(mouseY);
    }

    public boolean method_25406(double x, double y, int type) {
        this.scrollerManager.disableScrollWork();
        return super.method_25406(x, y, type);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    protected static class RenderableConfigInstance<T extends ConfigInstance<?>> {
        protected final ConfigRenderer.ConfigRenderingContext context;
        private final T instance;
        private final ConfigRenderer<T> renderer;
        private final class_768 box = new class_768(0, 0, 0, 0);

        protected RenderableConfigInstance(T instance, ConfigRenderer.ConfigRenderingContext ctx) {
            this.context = ctx;
            this.instance = instance;
            this.renderer = ((ConfigInstance)instance).getRenderer();
        }

        public void render(GuiUtils gui, int x, int y, int length, int height, boolean mainPhase) {
            this.box.method_35779(x, y);
            this.box.method_35782(length);
            this.box.method_35783(height);
            if (mainPhase) {
                this.renderer.render(gui, this.instance, this.box);
            } else {
                this.renderer.renderBackground(gui, this.instance, this.box);
                this.renderer.renderOptionName(gui, this.instance, this.box);
            }
        }

        public void renderTooltip(GuiUtils gui) {
            this.renderer.renderTooltip(gui, this.instance, this.box);
        }

        public boolean mouseClicked(double mouseX, double mouseY) {
            return this.renderer.mouseClicked(this.instance, mouseX, mouseY, this.box, this.context);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double yOffsetWheel) {
            return this.renderer.mouseScrolled(this.instance, mouseX, mouseY, yOffsetWheel, this.box, this.context);
        }
    }
}

