/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.config;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.config.ConfigInstance;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public interface ConfigRenderer<T extends ConfigInstance<?>> {
    public static final String LOCAL_KEY = "blockomorph.config_option.";
    public static final int MAX_NAME_WIDTH = 85;
    public static final int MAX_Y = 119;
    public static final int MAX_X = 186;
    public static final class_2960 PLATES_SPRITE = GuiUtils.res("textures/screens/configs.png");

    public void renderBackground(GuiUtils var1, T var2, class_768 var3);

    public void render(GuiUtils var1, T var2, class_768 var3);

    public boolean mouseClicked(T var1, double var2, double var4, class_768 var6, ConfigRenderingContext var7);

    public boolean mouseScrolled(T var1, double var2, double var4, double var6, class_768 var8, ConfigRenderingContext var9);

    default public void renderOptionName(GuiUtils gui, T configInstance, class_768 box) {
        class_5250 name = class_2561.method_43471((String)(LOCAL_KEY + ((ConfigInstance)configInstance).getName()));
        int stringLength = gui.getFont().method_1727(name.getString());
        if (stringLength > 85) {
            name = class_2561.method_43470((String)(gui.getFont().method_27523(name.getString(), 85) + ".."));
        }
        gui.drawString((class_2561)name, box.method_3321() + 4, box.method_3322() + 5, this.getOptionColor(configInstance), false);
    }

    default public void renderTooltip(GuiUtils gui, T configInstance, class_768 box) {
        if (GuiUtils.isMouseOver(box.method_3321(), box.method_3322(), box.method_3321() + 85 + 5, box.method_3322() + box.method_3320(), gui.getMouseX(), gui.getMouseY())) {
            ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
            class_2561 tooltip = this.getTooltip(gui, configInstance);
            if (tooltip != null) {
                tooltips.add(tooltip);
            }
            if (((ConfigInstance)configInstance).getTooltip() != null) {
                tooltips.add(((ConfigInstance)configInstance).getTooltip());
            }
            gui.renderTooltip(tooltips, gui.getMouseX(), gui.getMouseY());
        }
    }

    @Nullable
    default public class_2561 getTooltip(GuiUtils gui, T configInstance) {
        class_5250 name = class_2561.method_43471((String)(LOCAL_KEY + ((ConfigInstance)configInstance).getName()));
        if (gui.getFont().method_1727(name.getString()) > 85) {
            return name;
        }
        return null;
    }

    default public int getOptionColor(T configInstance) {
        return -1;
    }

    default public void startClick() {
    }

    default public void endClick() {
    }

    default public void init() {
    }

    public record ConfigRenderingContext(class_437 parentScreen, BiConsumer<String, String> onValueChanged, Consumer<class_437> onNewScreenRequested, Consumer<ConfigInstance<?>> onEnteringRequested) {
    }
}

