/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.blockomorph.screens.morphConfig.nbtEditor.NbtEditorScreen;
import net.blockomorph.screens.morphConfig.nbtEditor.TagTypes;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers.TagRenderer;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.screens.utils.ObjectListRenderer;
import net.blockomorph.utils.MorphUtils;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4614;
import net.minecraft.class_5244;
import org.jetbrains.annotations.Nullable;

public class TagAddingOverlay<T extends class_2520>
extends TagEditingOverlay {
    private static final class_2960 MENU = GuiUtils.res("textures/screens/tag_adding_screen.png");
    private int tagBoxX;
    private int tagBoxY;
    private final ObjectListRenderer<TagTypes, class_4614<? extends T>> selector;
    private final BiConsumer<String, T> onTagCreated;
    private CachedType<? extends T> currentType;
    private final class_4614<? extends T> first;
    @Nullable
    private final Supplier<String> nameSuggestion;
    @Nullable
    private final List<class_2561> hint;
    private int leftPos;
    private int topPos;
    private final boolean listDisabled;
    private final Predicate<String> filter;
    private class_342 name;

    @SafeVarargs
    public TagAddingOverlay(Predicate<String> nameFilter, BiConsumer<String, T> onTagCreated, @Nullable Supplier<String> nameSuggestion, @Nullable List<class_2561> hint, boolean needInterpritation, class_4614<? extends T> ... types) {
        super(159, 59);
        List<class_4614<?>> registered = List.of(TagTypes.getRegisteredTags());
        List<class_4614> filtered = Stream.of(types).filter(type -> {
            if (registered.contains(type)) {
                return true;
            }
            MorphUtils.LOGGER.error("Tag " + type.method_23259() + " not registered and not be added!");
            return false;
        }).toList();
        if (filtered.isEmpty()) {
            throw new IllegalArgumentException("Types array is empty!");
        }
        this.selector = new ObjectListRenderer<TagTypes, class_4614>(-1, -256, 7, (tagTypes, tagType) -> tagType.method_23261().replace("TAG_", "").replace("_", " "), tagTypes -> filtered);
        this.onTagCreated = onTagCreated;
        this.listDisabled = filtered.size() == 1;
        this.filter = nameFilter;
        this.first = filtered.get(0);
        this.nameSuggestion = nameSuggestion;
        this.hint = hint;
    }

    private <TAG extends T> void setCurrentType(class_4614<TAG> type) {
        Supplier<TAG> creator = TagTypes.createDefaultTag(type);
        this.currentType = new CachedType<class_2520>(type, creator, TagTypes.getRendererForTag(null, (class_2520)Objects.requireNonNull(creator).get(), null));
        this.currentType.renderer.getBox().method_35779(this.tagBoxX, this.tagBoxY);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int type) {
        if (type == 0) {
            if (!this.listDisabled) {
                int x = this.tagBoxX;
                int y = this.tagBoxY;
                if (this.selector.mouseClicked(mouseX, mouseY)) {
                    return true;
                }
                if (GuiUtils.isMouseOver(x, y, x + 54, y + 20, mouseX, mouseY)) {
                    this.selector.drop(null, tagType -> {
                        GuiUtils.playClickSound();
                        this.setCurrentType((class_4614)tagType);
                    });
                    GuiUtils.playClickSound();
                    return true;
                }
                this.selector.close();
            }
            return super.method_25402(mouseX, mouseY, 0);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double yWheelOffset) {
        return this.selector.mouseScrolled(mouseX, mouseY, yWheelOffset);
    }

    public boolean method_25404(int key, int scancode, int mods) {
        if (key == 257) {
            this.acceptTag();
            GuiUtils.playClickSound();
            return true;
        }
        return super.method_25404(key, scancode, mods);
    }

    @Override
    protected void renderInGui(GuiUtils gui) {
        int x = this.tagBoxX + 6;
        int y = this.tagBoxY + 6;
        this.selector.renderName(gui, x, y, 38, null, this.currentType.type, -1);
        this.selector.render(gui, x, y, -1, 10);
        if (this.nameSuggestion != null && this.name.method_1882().isEmpty() && !this.name.method_49606()) {
            gui.drawString((class_2561)class_2561.method_43470((String)this.nameSuggestion.get()), this.name.method_46426() + 4, this.name.method_46427() + (this.name.method_25364() - 8) / 2, -8355712, true);
        }
        if (this.hint != null && this.name.method_49606()) {
            int n = this.hint.size();
            Objects.requireNonNull(gui.getFont());
            int height = 6 + n * 9 + 18;
            gui.renderTooltip(this.hint, this.name.method_46426() - 12, this.name.method_46427() - height + 12);
        }
    }

    public void acceptTag() {
        class_2520 tag = (class_2520)this.currentType.creator.get();
        this.onTagCreated.accept(this.name.method_1882(), (String)tag);
        this.onChange.accept(null);
    }

    @Override
    protected void renderBackground(GuiUtils gui) {
        TagRenderer renderer = this.currentType.renderer;
        gui.blitMonoImage(MENU, this.leftPos, this.topPos, this.imageLength, this.imageHeight);
        gui.enableScrissors(this.tagBoxX, this.tagBoxY, this.tagBoxX + 50, this.tagBoxY + 20);
        renderer.renderPlateWithoutCtx(gui);
        gui.disableScrissors();
        int x = this.tagBoxX + 50;
        gui.enableScrissors(x, this.tagBoxY, x + 4, this.tagBoxY + 20);
        int plateX = x - (renderer.getBox().method_3319() - 4);
        int oldX = renderer.getBox().method_3321();
        renderer.getBox().method_35778(plateX);
        renderer.renderPlateWithoutCtx(gui);
        renderer.getBox().method_35778(oldX);
        gui.disableScrissors();
        gui.blit(NbtEditorScreen.BUTTONS_SPRITE, this.tagBoxX + 4, this.tagBoxY + 4, 0.0f, 32.0f, 46, 11, 46, 43);
    }

    @Override
    public void init(int width, int height, Consumer<TagEditingOverlay> onChange) {
        super.init(width, height, onChange);
        this.leftPos = (this.width - this.imageLength) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.tagBoxX = this.leftPos + 99;
        this.tagBoxY = this.topPos + 7;
        if (this.currentType == null) {
            this.setCurrentType(this.first);
        }
        this.currentType.renderer.getBox().method_35779(this.tagBoxX, this.tagBoxY);
        String nameValue = this.name != null ? this.name.method_1882() : "";
        this.name = new class_342(GuiUtils.MC.field_1772, this.leftPos + 7, this.topPos + 7, 89, 20, (class_2561)class_2561.method_43470((String)"name"));
        this.name.method_1890(this.filter);
        this.addRenderableWidget((class_339)this.name);
        this.name.method_1852(nameValue);
        class_4185 done = new class_4185(this.leftPos + 7, this.topPos + 32, 146, 20, class_5244.field_24334, b -> this.acceptTag(), Supplier::get){

            protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float tick) {
                this.field_22762 = this.method_25405(mouseX, mouseY) && !TagAddingOverlay.this.selector.isListFocused(mouseX, mouseY);
                super.method_48579(guiGraphics, mouseX, mouseY, tick);
            }
        };
        this.addRenderableWidget((class_339)done);
        this.method_25395((class_364)this.name);
    }

    private record CachedType<T extends class_2520>(class_4614<T> type, Supplier<T> creator, TagRenderer<T> renderer) {
    }
}

