/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.morphConfig.nbtEditor.renderers.tagRenderers;

import java.util.List;
import java.util.Objects;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.TagRendererContext;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.interpritationTagRenderers.AbstractInterpritationTagRenderer;
import net.blockomorph.screens.morphConfig.nbtEditor.renderers.overlays.TagEditingOverlay;
import net.blockomorph.screens.utils.GuiUtils;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

public abstract class TagRenderer<T extends class_2520> {
    protected static final int MAX_NAME_WIDTH = 53;
    public static final int PLATE_SPRITE_LENGTH = 194;
    public static final int PLATE_SPRITE_HEIGTH = 200;
    public static final int PLATE_LENGTH = 144;
    public static final int PLATE_HEIGTH = 20;
    protected static final class_2960 TAGS_SPRITE = GuiUtils.res("textures/screens/tags.png");
    protected final TagRendererContext<T> tagRendererContext;
    protected final class_768 box = new class_768(0, 0, 144, 20);
    private T tag;
    private final String name;
    private boolean nameVisibility = true;

    public TagRenderer(String tagName, T tag, TagRendererContext<T> ctx) {
        this.name = tagName;
        this.tag = tag;
        this.tagRendererContext = ctx;
    }

    public void setNameVisibility(boolean yes) {
        this.nameVisibility = yes;
    }

    protected boolean hasName() {
        return this.nameVisibility;
    }

    protected void enterInTag() {
        if (this.canEnterInTag()) {
            this.tagRendererContext.onEntering().accept(this.name, false);
        }
    }

    protected void changeThis(T newSelf) {
        Objects.requireNonNullElse(this.tagRendererContext.onTagUpdate(), v -> {}).accept((class_2520)newSelf);
        this.tag = newSelf;
        this.tagRendererContext.onMainTagEdited().run();
    }

    public void forceTagChange(T newSelf) {
        this.tag = newSelf;
    }

    public void renderPlateWithoutCtx(GuiUtils gui) {
        if (this.getPlateNumber() != null) {
            this.renderPlate(gui, this.getPlateNumber());
        }
    }

    protected void renderPlate(GuiUtils gui, int number) {
        gui.blit(TAGS_SPRITE, this.box.method_3321(), this.box.method_3322(), 0.0f, 20 * number, 144, 20, 194, 200);
        this.renderLine(gui, number);
    }

    protected void renderLine(GuiUtils gui, int number) {
        if (!this.nameVisibility) {
            gui.blit(TAGS_SPRITE, this.box.method_3321() + 57, this.box.method_3322(), 55.0f, 20 * number, 2, 20, 194, 200);
        }
    }

    protected void renderDynamicColorLine(GuiUtils gui) {
        gui.blit(TAGS_SPRITE, this.box.method_3321() + 57, this.box.method_3322(), 176 + (this.nameVisibility ? 0 : 2), 0.0f, 2, 20, 194, 200);
    }

    protected void drawTextPart(GuiUtils gui) {
        if (this.nameVisibility) {
            String name = gui.getFont().method_27523(this.name, 53) + (gui.getFont().method_1727(this.name) > 58 ? ".." : "");
            gui.drawString((class_2561)class_2561.method_43470((String)name), this.box.method_3321() + 4, this.box.method_3322() + 5, -1, false);
        }
    }

    @Nullable
    public class_2561 getTooltip(GuiUtils gui) {
        if (GuiUtils.isMouseOver(this.box.method_3321(), this.box.method_3322(), this.box.method_3321() + 53 + 5, this.box.method_3322() + this.box.method_3320(), gui.getMouseX(), gui.getMouseY()) && gui.getFont().method_1727(this.name) > 58) {
            return class_2561.method_43470((String)this.name);
        }
        return null;
    }

    public T getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public class_768 getBox() {
        return this.box;
    }

    public final void renderTag(GuiUtils gui) {
        Integer number = this.getPlateNumber();
        if (number != null) {
            this.renderPlate(gui, number);
        }
        this.drawTextPart(gui);
        this.render(gui);
    }

    public abstract void render(GuiUtils var1);

    public boolean mouseClicked(double mouseX, double mouseY) {
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double yOffsetWheel) {
        return false;
    }

    public boolean keyPressed(int key, int scancode, int mods) {
        return false;
    }

    public boolean charTyped(char character, int mods) {
        return false;
    }

    public boolean canEnterInTag() {
        return false;
    }

    public int getFrameColor() {
        return -1;
    }

    @Nullable
    protected Integer getPlateNumber() {
        return null;
    }

    public List<TagRenderer<?>> getEnteringTags() {
        return List.of();
    }

    public class_2520 tryWalk(String nameElementInThisTag) {
        return null;
    }

    @Nullable
    public TagEditingOverlay getTagAddOverlay() {
        return null;
    }

    public void deleteTag(String name) {
    }

    @Nullable
    public AbstractInterpritationTagRenderer<T> getInterpretationRenderer(Runnable onInterpretationBrake) {
        return null;
    }
}

