/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.mixins.main.server;

import com.mojang.authlib.GameProfile;
import net.blockomorph.utils.BannedBlock;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin
extends class_1657 {
    @Shadow
    public abstract boolean method_5873(class_1297 var1, boolean var2);

    public ServerPlayerMixin(class_1937 p_250508_, GameProfile p_252153_) {
        super(p_250508_, p_252153_);
    }

    @ModifyVariable(method={"setRespawnPosition"}, at=@At(value="HEAD"))
    private class_3222.class_10766 modifyBlockPos(class_3222.class_10766 originalPos) {
        if (originalPos == null) {
            return null;
        }
        class_2338 newPos = InPlayerBlockPos.checkOnReal(originalPos.comp_3684());
        return new class_3222.class_10766(originalPos.comp_3683(), newPos, originalPos.comp_3685(), newPos != originalPos.comp_3684() || originalPos.comp_3686());
    }

    @Inject(method={"startSleeping"}, at={@At(value="TAIL")})
    public void bound(class_2338 pos, CallbackInfo ci) {
        InPlayerBlockPos.check(pos, (pl, realPos) -> this.method_5873((class_1297)pl.player(), true), null, (class_4538)this.method_37908());
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="HEAD")})
    public void unbound(boolean p_9165_, boolean p_9166_, CallbackInfo ci) {
        this.method_18398().ifPresent(blockpos -> {
            if (InPlayerBlockPos.isMorphedPlayerX(blockpos.method_10263())) {
                this.method_5848();
            }
        });
    }

    @Inject(method={"isReachableBedBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void realInRange(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        if (InPlayerBlockPos.isMorphedPlayerX(pos.method_10263())) {
            class_243 real = InPlayerBlockPos.checkOnReal(class_243.method_24955((class_2382)pos));
            cir.setReturnValue((Object)(Math.abs(this.method_23317() - real.method_10216()) <= 3.0 && Math.abs(this.method_23318() - real.method_10214()) <= 2.0 && Math.abs(this.method_23321() - real.method_10215()) <= 3.0 ? 1 : 0));
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    public void dead(class_1282 damageSource, CallbackInfo ci) {
        if (PlayerAccessor.of(this).isFullActive() && !damageSource.method_49708(MorphUtils.PLAYER_DESTROYED) && !damageSource.method_49708(MorphUtils.PLAYER_DESTROYED_NULL)) {
            PlayerAccessor.of(this).getBlocksData2().values().forEach(block -> this.method_37908().method_20290(2001, block.getPos(), class_2248.method_9507((class_2680)block.getBlockState())));
        }
    }

    @Inject(method={"restoreFrom"}, at={@At(value="TAIL")})
    public void restoreBlockMorphData(class_3222 old, boolean fromEnd, CallbackInfo ci) {
        PlayerAccessor pl = PlayerAccessor.of(this);
        PlayerAccessor oldPl = PlayerAccessor.of((class_1657)old);
        if (!fromEnd && Config.getInstance().getValue("playerDieAfterDestroy", Boolean.class).booleanValue()) {
            pl.applyBlockMorph(class_2246.field_10124.method_9564(), null, BannedBlock.Source.SYSTEM);
            for (InPlayerBlockPos pos : oldPl.getUpdates()) {
                pl.prepareSync(pos);
            }
        } else {
            pl.loadBlockData(oldPl.saveBlockData(false), null, true);
        }
    }

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")}, cancellable=true)
    public void hurt(class_3218 lv, class_1282 damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        if (MorphUtils.onPlayerAttacked((class_1309)this, damageSource, f)) {
            cir.setReturnValue((Object)false);
        }
    }
}

