/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.screens.utils;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.blockomorph.screens.utils.GuiUtils;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.accessors.SpriteAccessor;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public final class FogLiquidModifier {
    @Nullable
    public LiquidFogData getFog(Iterable<class_1297> entities, boolean includeVanilla) {
        AtomicReference fogData = new AtomicReference();
        class_4184 camera = GuiUtils.MC.field_1773.method_19418();
        class_4184.class_6355 nearPlane = camera.method_36425();
        for (class_243 pos : Arrays.asList(nearPlane.method_36427(0.0f, 0.0f), nearPlane.method_36426(), nearPlane.method_36429(), nearPlane.method_36430(), nearPlane.method_36431())) {
            class_243 position = camera.method_19326().method_1019(pos);
            MorphUtils.doBlockInMorphedPlayerOnPos(camera.method_19331(), entities, position, (pl, block) -> {
                if (block.shouldDoFluidAction()) {
                    class_3610 fluidState = block.getBlockState().method_26227();
                    if (includeVanilla || !fluidState.method_15767(class_3486.field_15517) && !fluidState.method_15767(class_3486.field_15518)) {
                        fogData.set(this.calculateData(camera.method_19331().method_37908(), (BlockInPlayer2)block));
                    }
                }
            });
        }
        return (LiquidFogData)fogData.get();
    }

    private LiquidFogData calculateData(class_1937 lv, BlockInPlayer2 block) {
        try {
            Map.Entry<class_1058, Integer> info = FogLiquidModifier.getPlatformFluidTexture(lv, block);
            if (info == null) break block6;
            if (info.getKey() != null) {
                class_1058 sprite = info.getKey();
                class_1011 image = SpriteAccessor.of(sprite.method_45851()).getImage();
                int argbPixel = image.method_61940(image.method_4307() / 2, image.method_4323() / 2);
                if (info.getValue() != null) {
                    argbPixel = class_9848.method_61319((float)0.5f, (int)argbPixel, (int)info.getValue());
                }
                float start = -8.0f;
                float end = 36.0f;
                if (class_9848.method_61320((int)argbPixel) > 235) {
                    start = 0.25f;
                    end = 1.0f;
                }
                return new LiquidFogData(start, end, argbPixel);
            }
        }
        finally {
            return null;
        }
        {
            block6: {
            }
        }
    }

    private static Map.Entry<class_1058, Integer> getPlatformFluidTexture(class_1937 lv, BlockInPlayer2 block) {
        class_3610 state = block.getBlockState().method_26227();
        FluidRenderHandler info = FluidRenderHandlerRegistry.INSTANCE.get(state.method_15772());
        if (info != null) {
            int tint = info.getFluidColor((class_1920)lv, block.getPos(), state);
            return new AbstractMap.SimpleEntry<class_1058, Integer>(info.getFluidSprites((class_1920)lv, block.getPos(), state)[0], tint == -1 ? null : Integer.valueOf(tint));
        }
        return null;
    }

    @Nullable
    public static Integer getPlatformFluidTint(class_1937 lv, BlockInPlayer2 block) {
        class_3610 state = block.getBlockState().method_26227();
        FluidRenderHandler info = FluidRenderHandlerRegistry.INSTANCE.get(state.method_15772());
        if (info != null) {
            int tint = info.getFluidColor((class_1920)lv, block.getPos(), state);
            return tint == -1 ? null : Integer.valueOf(tint);
        }
        return null;
    }

    public record LiquidFogData(float start, float end, int color) {
    }
}

