/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.blockomorph.network.ClientBoundMorphUpdatePacket;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.MorphedBlockEntityProblemReporter;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.BlockPosBounds;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;

public class BlockInPlayer2 {
    private final InPlayerBlockPos offset;
    private final class_2338 pos;
    private final class_1657 player;
    private class_2680 blockState;
    private class_2586 blockEntity;
    private class_5558 blockEntityTicker;

    public BlockInPlayer2(PlayerAccessor pl, InPlayerBlockPos pos, class_2680 state, Consumer<BlockInPlayer2> preInit) {
        this.offset = pos;
        this.pos = pos.boundedBlockPos(pl.player());
        if (this.pos == null) {
            throw new IllegalArgumentException("Null BlockPos in BlockInPlayer! Player section: " + String.valueOf(BlockPosBounds.getChunkPosForPlayer(pl.player())) + " Level: " + String.valueOf(pl.player().method_37908()));
        }
        this.player = pl.player();
        this.blockState = state;
        preInit.accept(this);
        this.initBlockEntity();
        this.initTicker();
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public class_2586 getBlockEntity() {
        return this.blockEntity;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public InPlayerBlockPos getOffset() {
        return this.offset;
    }

    protected boolean shouldShowFluidState() {
        return Config.getInstance().getValue("liquidsInBlocks", Boolean.class);
    }

    public boolean shouldDoFluidAction() {
        return this.blockState.method_26204() instanceof class_2404 || !this.blockState.method_26227().method_15769() && this.shouldShowFluidState();
    }

    @Nullable
    public List<String> loadNBT(class_2487 tg) {
        if (this.blockEntity != null) {
            try {
                MorphedBlockEntityProblemReporter collector = new MorphedBlockEntityProblemReporter(25, 200);
                class_11368 valueInput = class_11352.method_71417((class_8942)collector, (class_7225.class_7874)this.player.method_37908().method_30349(), (class_2487)tg);
                this.blockEntity.method_58690(valueInput);
                return collector.getProblemsIfNotEmpty();
            }
            catch (Throwable e) {
                return List.of(Objects.requireNonNullElse(e.getMessage(), e.getClass().getName()));
            }
        }
        return null;
    }

    public BlockInPlayer2 handleClientTag(class_2487 tg, ClientBoundMorphUpdatePacket pkt) {
        if (this.blockEntity != null) {
            try {
                class_2622.method_39026((class_2586)this.blockEntity, (ent, access) -> tg).method_11292((class_2602)pkt.getListener());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public void onPlace(class_2680 newState, class_2680 oldState, int flags) {
        if (!this.player.method_37908().field_9236) {
            newState.method_26182(this.player.method_37908(), this.pos, oldState, (flags & 0x40) != 0);
        }
    }

    public BlockInPlayer2 changeBlockState(class_2680 state, int flags) {
        boolean bl5;
        class_2680 old = this.blockState;
        this.blockState = state;
        boolean newBlock = !old.method_27852(state.method_26204());
        boolean bl4 = (flags & 0x40) != 0;
        boolean bl = bl5 = (flags & 0x100) == 0;
        if (newBlock && old.method_31709()) {
            if (!this.player.method_37908().field_9236 && bl5 && this.blockEntity != null) {
                this.blockEntity.method_66473(this.pos, old);
            }
            this.clearBlockEntity();
        }
        if (newBlock || state.method_26204() instanceof class_2241) {
            this.checkUpdates(flags, old);
        }
        if (!this.player.method_37908().field_9236 && (flags & 0x200) == 0) {
            this.onPlace(state, old, flags);
        }
        if (state.method_31709()) {
            if (this.blockEntity == null) {
                this.initBlockEntity();
            } else {
                this.blockEntity.method_31664(state);
            }
        }
        this.initTicker();
        return this;
    }

    public void checkUpdates(int flags, class_2680 old) {
        class_1937 class_19372 = this.player.method_37908();
        if (class_19372 instanceof class_3218) {
            boolean bl4;
            class_3218 serverLevel = (class_3218)class_19372;
            boolean bl = bl4 = (flags & 0x40) != 0;
            if ((flags & 1) != 0 || bl4) {
                old.method_66478(serverLevel, this.pos, bl4);
            }
        }
    }

    public void clearBlockEntity() {
        this.blockEntity = null;
        this.blockEntityTicker = null;
    }

    private void initBlockEntity() {
        class_2248 class_22482 = this.blockState.method_26204();
        if (class_22482 instanceof class_2343) {
            class_2343 ent = (class_2343)class_22482;
            this.blockEntity = ent.method_10123(this.pos, this.blockState);
            if (this.blockEntity != null) {
                this.blockEntity.method_31662(this.player.method_37908());
            }
        }
    }

    private void initTicker() {
        class_2248 class_22482 = this.blockState.method_26204();
        if (class_22482 instanceof class_2343) {
            class_2343 ent = (class_2343)class_22482;
            if (this.blockEntity != null) {
                this.blockEntityTicker = ent.method_31645(this.player.method_37908(), this.blockState, this.blockEntity.method_11017());
            }
        }
    }

    public void tick() {
        if (this.blockEntity != null && this.blockEntityTicker != null) {
            try {
                this.blockEntityTicker.tick(this.player.method_37908(), this.pos, this.blockState, this.blockEntity);
            }
            catch (Exception e) {
                this.blockEntityTicker = null;
                MorphUtils.LOGGER.error("An unexpected exception occurred while ticking a block entity in a transformed player with username " + this.player.method_5477().getString() + ": ", (Throwable)e);
            }
        }
    }

    public void animateTick(class_5819 randomSource, class_2248 marker, Consumer<class_2680> needSpawnFluidDrip) {
        class_3610 fluidState;
        if (this.player.method_37908().field_9236) {
            this.blockState.method_26204().method_9496(this.blockState, this.player.method_37908(), this.pos, randomSource);
        }
        if (this.shouldDoFluidAction() && !(fluidState = this.blockState.method_26227()).method_15769()) {
            fluidState.method_15768(this.player.method_37908(), this.pos, randomSource);
            needSpawnFluidDrip.accept(PlayerAccessor.of(this.player).getBlockState(this.offset.offset(0, -1, 0)));
        }
        if (this.blockState.method_26204() == marker) {
            class_243 real = MorphUtils.getCetneredRealBlockPos(PlayerAccessor.of(this.player), this.offset);
            this.player.method_37908().method_8406((class_2394)new class_2388(class_2398.field_35434, this.blockState), real.field_1352, real.field_1351, real.field_1350, 0.0, 0.0, 0.0);
        }
    }
}

