/*
 * Decompiled with CFR 0.152.
 */
package net.blockomorph.utils;

import java.util.Map;
import java.util.SortedSet;
import java.util.function.Consumer;
import net.blockomorph.utils.BlockInPlayer2;
import net.blockomorph.utils.MorphUtils;
import net.blockomorph.utils.PlayerAccessor;
import net.blockomorph.utils.VertexConsumerWrapper;
import net.blockomorph.utils.accessors.ClientLevelAccessor;
import net.blockomorph.utils.accessors.LevelRendererAccessor;
import net.blockomorph.utils.config.Config;
import net.blockomorph.utils.coords.InPlayerBlockPos;
import net.blockomorph.utils.hit.MorphedPlayerHitResult;
import net.minecraft.class_10017;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_11515;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4184;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_4720;
import net.minecraft.class_5819;
import net.minecraft.class_742;
import net.minecraft.class_765;
import net.minecraft.class_776;
import net.minecraft.class_824;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import org.joml.Vector3f;

public class MorphedPlayerRenderer {
    private final class_310 mc = class_310.method_1551();
    private final class_776 blockRenderDispatcher = this.mc.method_1541();
    private final class_898 entityDispatcher = this.mc.method_1561();
    private final class_824 blockEntityRenderDispatcher = this.mc.method_31975();
    private final class_4597 crumblBuffer = this.mc.method_22940().method_23001();
    private final class_5819 RANDOM = class_5819.method_43047();

    public boolean render(boolean translucent, class_742 player, float partialticks, class_4587 posestack, class_4597 buffer, int light, Consumer<Float> shadow) {
        if (player instanceof PlayerAccessor) {
            PlayerAccessor pl = (PlayerAccessor)player;
            if (pl.isFullActive()) {
                shadow.accept(Float.valueOf(0.0f));
                posestack.method_22903();
                this.adjustMatrixForPlayer(posestack, pl, player);
                this.renderBlock(translucent, player, posestack, buffer, pl);
                this.renderBlockEntity(player, partialticks, posestack, buffer, pl);
                this.renderBreak(player, posestack, buffer, pl);
                this.renderFrame(posestack, buffer, pl);
                posestack.method_22909();
                return true;
            }
            if (pl.getTnt() != null && !translucent) {
                this.renderTnt(player, partialticks, posestack, buffer, light, pl);
                return true;
            }
        }
        return false;
    }

    private void renderTnt(class_742 player, float partialticks, class_4587 posestack, class_4597 buffer, int light, PlayerAccessor pl) {
        class_1541 tnt = pl.getTnt();
        class_897 rend = this.entityDispatcher.method_3953((class_1297)pl.getTnt());
        class_10017 state = rend.method_62425((class_1297)tnt, partialticks);
        try {
            rend.method_3936(state, posestack, buffer, light);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void adjustMatrixForPlayer(class_4587 poseStack, PlayerAccessor pl, class_742 player) {
        InPlayerBlockPos minpos = pl.minPos();
        class_238 hitbox = player.method_5829();
        class_243 playerCenter = player.method_19538();
        double offsetX = hitbox.field_1323 - (playerCenter.field_1352 + (double)minpos.getX());
        double offsetZ = hitbox.field_1321 - (playerCenter.field_1350 + (double)minpos.getZ());
        poseStack.method_22904(offsetX, 0.0, offsetZ);
    }

    private class_2338 getPosForOffset(BlockInPlayer2 ctr) {
        return ctr.getPos();
    }

    public void renderBlock(boolean translucent, class_742 player, class_4587 posestack, class_4597 buffer, PlayerAccessor pl) {
        for (Map.Entry<InPlayerBlockPos, BlockInPlayer2> entry : pl.getBlocksData2().entrySet()) {
            BlockInPlayer2 bl = entry.getValue();
            class_2680 st = bl.getBlockState();
            InPlayerBlockPos pos = entry.getKey();
            posestack.method_22903();
            posestack.method_46416((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            if (st.method_26217() == class_2464.field_11458) {
                this.renderBlock(translucent, player, st, posestack, buffer, bl);
            }
            if (bl.shouldDoFluidAction()) {
                this.renderLiquid(translucent, bl, posestack, buffer, pl);
            }
            posestack.method_22909();
        }
    }

    private void renderBlock(boolean translucent, class_742 player, class_2680 blockstate, class_4587 posestack, class_4597 buffer, BlockInPlayer2 block) {
        class_1937 level = player.method_37908();
        class_1087 model = this.blockRenderDispatcher.method_3349(blockstate);
        class_2338 offset = this.getPosForOffset(block);
        class_1921 renderType = class_4696.method_29359((class_2680)blockstate);
        if (translucent != (renderType == class_1921.method_29380())) {
            return;
        }
        class_4588 vertex = buffer.getBuffer(renderType);
        this.RANDOM.method_43052(blockstate.method_26190(offset));
        this.blockRenderDispatcher.method_3350().method_3374((class_1920)level, model.method_68512(this.RANDOM), blockstate, offset, posestack, vertex, true, class_4608.field_21444);
    }

    private void renderLiquid(boolean translucent, BlockInPlayer2 block, final class_4587 posestack, class_4597 buffer, PlayerAccessor pl) {
        class_3610 fluidState = block.getBlockState().method_26227();
        if (!fluidState.method_15769()) {
            class_2338 pos = block.getPos();
            class_11515 layer = class_4696.method_23680((class_3610)fluidState);
            class_1921 renderType = switch (layer) {
                case class_11515.field_60924 -> class_1921.method_23579();
                case class_11515.field_60925 -> class_1921.method_23581();
                case class_11515.field_60926 -> class_1921.method_29380();
                case class_11515.field_60927 -> class_1921.method_29997();
                default -> class_1921.method_23577();
            };
            if (translucent != (renderType == class_1921.method_29380())) {
                return;
            }
            final float xOffset = pos.method_10263() & 0xF;
            final float yOffset = pos.method_10264() & 0xF;
            final float zOffset = pos.method_10260() & 0xF;
            VertexConsumerWrapper vertexConsumer = new VertexConsumerWrapper(this, buffer.getBuffer(renderType)){

                @Override
                public class_4588 method_22912(float x, float y, float z) {
                    Vector3f realPos = posestack.method_23760().method_23761().transformPosition(x - xOffset, y - yOffset, z - zOffset, new Vector3f());
                    return super.method_22912(realPos.x(), realPos.y(), realPos.z());
                }
            };
            ClientLevelAccessor acc = ClientLevelAccessor.of(pl.player().method_37908());
            try {
                acc.lockExternalMorphedBlockGetter(true);
                this.blockRenderDispatcher.method_3352(pos, (class_1920)pl.player().method_37908(), (class_4588)vertexConsumer, block.getBlockState(), fluidState);
                acc.lockExternalMorphedBlockGetter(false);
            }
            catch (class_148 class_1482) {
                // empty catch block
            }
        }
    }

    private void renderBlockEntity(class_742 player, float partialticks, class_4587 posestack, class_4597 buffer, PlayerAccessor pl) {
        for (Map.Entry<InPlayerBlockPos, BlockInPlayer2> entry : pl.getBlocksData2().entrySet()) {
            InPlayerBlockPos pos = entry.getKey();
            posestack.method_22903();
            posestack.method_46416((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            this.renderBlockEntity(entry.getValue(), player, partialticks, posestack, buffer, this.getRenderLight(player, this.getPosForOffset(entry.getValue())), pl);
            posestack.method_22909();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderBlockEntity(BlockInPlayer2 data, class_742 player, float partialticks, class_4587 posestack, class_4597 buffer, int light, PlayerAccessor pl) {
        class_2586 blockEntity = data.getBlockEntity();
        if (blockEntity != null) {
            posestack.method_22903();
            try {
                class_827 renderer = this.blockEntityRenderDispatcher.method_3550(blockEntity);
                if (renderer != null) {
                    class_4597 src = buffer;
                    int k = this.getBrakeProgress(pl, blockEntity.method_11016());
                    if (k > -1 && k < 10) {
                        class_4587.class_4665 posestack$pose = posestack.method_23760();
                        class_4583 vertexconsumer = new class_4583(this.crumblBuffer.getBuffer((class_1921)class_1088.field_21772.get(k)), posestack$pose, 1.0f);
                        src = arg_0 -> MorphedPlayerRenderer.lambda$renderBlockEntity$0(buffer, (class_4588)vertexconsumer, arg_0);
                    }
                    ClientLevelAccessor acc = ClientLevelAccessor.of(blockEntity.method_10997());
                    acc.setSpecialRenderingMode(true);
                    class_4184 cam = class_310.method_1551().method_31975().field_4344;
                    renderer.method_3569(blockEntity, partialticks, posestack, src, light, class_4608.field_21444, cam.method_19326());
                    acc.setSpecialRenderingMode(false);
                }
            }
            catch (Exception exception) {
            }
            finally {
                posestack.method_22909();
            }
        }
    }

    private int getRenderLight(class_742 entity, class_2338 blockPos) {
        class_1937 lv = entity.method_37908();
        return class_765.method_23687((int)lv.method_8314(class_1944.field_9282, blockPos), (int)lv.method_8314(class_1944.field_9284, blockPos));
    }

    private void renderBreak(class_742 player, class_4587 posestack, class_4597 buffer, PlayerAccessor pl) {
        for (BlockInPlayer2 block : pl.getBlocksData2().values()) {
            class_2680 state = block.getBlockState();
            int k = this.getBrakeProgress(pl, block.getPos());
            posestack.method_22903();
            InPlayerBlockPos offset = block.getOffset();
            posestack.method_46416((float)offset.getX(), (float)offset.getY(), (float)offset.getZ());
            this.renderBreak(k, state, player, posestack, buffer, block);
            posestack.method_22909();
        }
    }

    private int getBrakeProgress(PlayerAccessor pl, class_2338 bounded) {
        if (Config.getInstance().getValue("hitReaction", Config.HitReaction.class) != Config.HitReaction.BRAKING) {
            class_1657 player = pl.player();
            float percentage = player.method_6032() / player.method_6063();
            if ((double)percentage < 0.03) {
                return 9;
            }
            int k = class_3532.method_15386((float)(percentage * 10.0f));
            return 9 - k;
        }
        return MorphedPlayerRenderer.getBrakeProgress(bounded);
    }

    public static int getBrakeProgress(class_2338 bounded) {
        class_3191 progress;
        LevelRendererAccessor acc = LevelRendererAccessor.of(class_310.method_1551().field_1769);
        SortedSet pos = (SortedSet)acc.getBrakingBlocks().get(bounded.method_10063());
        if (pos != null && (progress = (class_3191)pos.last()) != null) {
            return progress.method_13988();
        }
        return -1;
    }

    private void renderBreak(int k, class_2680 blockstate, class_742 player, class_4587 posestack, class_4597 buffer, BlockInPlayer2 block) {
        posestack.method_22903();
        class_4587.class_4665 posestack$pose1 = posestack.method_23760();
        if (k > -1 && k < 10) {
            class_4583 vertexconsumer1 = new class_4583(this.crumblBuffer.getBuffer((class_1921)class_1088.field_21772.get(k)), posestack$pose1, 1.0f);
            class_2338 offset = this.getPosForOffset(block);
            this.blockRenderDispatcher.method_23071(blockstate, offset, (class_1920)player.method_37908(), posestack, (class_4588)vertexconsumer1);
        }
        posestack.method_22909();
    }

    private void renderFrame(class_4587 posestack, class_4597 buffer, PlayerAccessor pl) {
        MorphedPlayerHitResult hit = this.shouldRenderFrame(pl);
        if (hit != null) {
            posestack.method_22903();
            class_265 shape = pl.getRenderShape(hit.getOffset(), (class_1657)this.mc.field_1724);
            if (shape == null) {
                posestack.method_22909();
                return;
            }
            int i = (Boolean)this.mc.field_1690.method_64858().method_41753() != false ? -11010079 : class_9848.method_61330((int)102, (int)-16777216);
            class_9974.method_62296((class_4587)posestack, (class_4588)buffer.getBuffer(class_1921.method_23594()), (class_265)shape, (double)0.0, (double)0.0, (double)0.0, (int)i);
            posestack.method_22909();
        }
    }

    private MorphedPlayerHitResult shouldRenderFrame(PlayerAccessor pl) {
        class_239 class_2392 = this.mc.field_1765;
        if (class_2392 instanceof MorphedPlayerHitResult) {
            MorphedPlayerHitResult hit = (MorphedPlayerHitResult)class_2392;
            if (!this.mc.field_1690.field_1842 && hit.getPlayer() == pl) {
                if (this.mc.field_1724.method_7325()) {
                    return MorphUtils.canOpenMenuIn(hit.getPlayer(), hit.getOffset()) ? hit : null;
                }
                if (this.mc.field_1761.method_2920() == class_1934.field_9216) {
                    return MorphUtils.isAdventureCanBreak(hit.getPlayer(), (class_1657)this.mc.field_1724, hit.getOffset()) ? hit : null;
                }
                return hit;
            }
        }
        return null;
    }

    private static /* synthetic */ class_4588 lambda$renderBlockEntity$0(class_4597 buffer, class_4588 vertexconsumer, class_1921 p_234298_) {
        class_4588 vertexconsumer2 = buffer.getBuffer(p_234298_);
        return p_234298_.method_23037() ? class_4720.method_24037((class_4588)vertexconsumer, (class_4588)vertexconsumer2) : vertexconsumer2;
    }
}

